/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools;

import java.util.Collection;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirector;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirectorFactory;

public class DroolsScoreDirector
extends AbstractScoreDirector<DroolsScoreDirectorFactory> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected KieSession kieSession;
    protected ScoreHolder workingScoreHolder;

    public DroolsScoreDirector(DroolsScoreDirectorFactory scoreDirectorFactory) {
        super(scoreDirectorFactory);
    }

    protected KieBase getKieBase() {
        return ((DroolsScoreDirectorFactory)this.scoreDirectorFactory).getKieBase();
    }

    public KieSession getKieSession() {
        return this.kieSession;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        super.setWorkingSolution(workingSolution);
        this.resetKieSession();
    }

    private void resetKieSession() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
        this.kieSession = this.getKieBase().newKieSession();
        this.workingScoreHolder = this.getScoreDefinition().buildScoreHolder(this.constraintMatchEnabledPreference);
        this.kieSession.setGlobal(GLOBAL_SCORE_HOLDER_KEY, (Object)this.workingScoreHolder);
        Collection<Object> workingFacts = this.getWorkingFacts();
        for (Object fact : workingFacts) {
            this.kieSession.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.getSolutionDescriptor().getAllFacts(this.workingSolution);
    }

    @Override
    public Score calculateScore() {
        this.kieSession.fireAllRules();
        Score score = this.workingScoreHolder.extractScore();
        this.setCalculatedScore(score);
        return score;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.workingScoreHolder.isConstraintMatchEnabled();
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        return this.workingScoreHolder.getConstraintMatchTotals();
    }

    @Override
    public DroolsScoreDirector clone() {
        return (DroolsScoreDirector)super.clone();
    }

    @Override
    public void dispose() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
            this.kieSession = null;
        }
    }

    @Override
    public void afterEntityAdded(EntityDescriptor entityDescriptor, Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @PlanningEntity.");
        }
        if (this.kieSession.getFactHandle(entity) != null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was already added to this ScoreDirector." + " Usually the cause is that that specific instance was already in your Solution's entities" + " and you probably want to use before/afterVariableChanged() instead.");
        }
        this.kieSession.insert(entity);
        super.afterEntityAdded(entityDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        this.update(entity);
        super.afterVariableChanged(variableDescriptor, entity);
    }

    private void update(Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's entities.");
        }
        this.kieSession.update(factHandle, entity);
    }

    @Override
    public void afterEntityRemoved(EntityDescriptor entityDescriptor, Object entity) {
        FactHandle factHandle = this.kieSession.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's entities.");
        }
        this.kieSession.delete(factHandle);
        super.afterEntityRemoved(entityDescriptor, entity);
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.kieSession.getFactHandle(problemFact) != null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was already added to this ScoreDirector." + " Usually the cause is that that specific instance was already in your Solution's getProblemFacts()" + " and you probably want to use before/afterProblemFactChanged() instead.");
        }
        this.kieSession.insert(problemFact);
        super.afterProblemFactAdded(problemFact);
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's getProblemFacts().");
        }
        this.kieSession.update(factHandle, problemFact);
        super.afterProblemFactChanged(problemFact);
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        FactHandle factHandle = this.kieSession.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector." + " Usually the cause is that that specific instance was not in your Solution's getProblemFacts().");
        }
        this.kieSession.delete(factHandle);
        super.afterProblemFactRemoved(problemFact);
    }
}

