/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simpledouble;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.impl.testdata.util.SerializationTestUtils;

public class SimpleDoubleScoreTest
extends AbstractScoreTest {
    @Test
    public void parseScore() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)-147.2), (Object)SimpleDoubleScore.parseScore((String)"-147.2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        SimpleDoubleScore.parseScore((String)"-147.2hard/-258.3soft");
    }

    @Test
    public void add() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)19.0), (Object)SimpleDoubleScore.valueOf((double)20.0).add(SimpleDoubleScore.valueOf((double)-1.0)));
    }

    @Test
    public void subtract() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)21.0), (Object)SimpleDoubleScore.valueOf((double)20.0).subtract(SimpleDoubleScore.valueOf((double)-1.0)));
    }

    @Test
    public void multiply() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)6.0), (Object)SimpleDoubleScore.valueOf((double)5.0).multiply(1.2));
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)1.2), (Object)SimpleDoubleScore.valueOf((double)1.0).multiply(1.2));
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)4.8), (Object)SimpleDoubleScore.valueOf((double)4.0).multiply(1.2));
    }

    @Test
    public void divide() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)5.0), (Object)SimpleDoubleScore.valueOf((double)25.0).divide(5.0));
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)4.2), (Object)SimpleDoubleScore.valueOf((double)21.0).divide(5.0));
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)4.8), (Object)SimpleDoubleScore.valueOf((double)24.0).divide(5.0));
    }

    @Test
    public void power() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)2.25), (Object)SimpleDoubleScore.valueOf((double)1.5).power(2.0));
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)1.5), (Object)SimpleDoubleScore.valueOf((double)2.25).power(0.5));
    }

    @Test
    public void negate() {
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)-1.5), (Object)SimpleDoubleScore.valueOf((double)1.5).negate());
        Assert.assertEquals((Object)SimpleDoubleScore.valueOf((double)1.5), (Object)SimpleDoubleScore.valueOf((double)-1.5).negate());
    }

    @Test
    public void equalsAndHashCode() {
        SimpleDoubleScoreTest.assertScoresEqualsAndHashCode(new Score[]{SimpleDoubleScore.valueOf((double)-10.0), SimpleDoubleScore.valueOf((double)-10.0)});
    }

    @Test
    public void compareTo() {
        SimpleDoubleScoreTest.assertScoreCompareToOrder(new Score[]{SimpleDoubleScore.valueOf((double)-300.5), SimpleDoubleScore.valueOf((double)-300.0), SimpleDoubleScore.valueOf((double)-20.06), SimpleDoubleScore.valueOf((double)-20.007), SimpleDoubleScore.valueOf((double)-20.0), SimpleDoubleScore.valueOf((double)-1.0), SimpleDoubleScore.valueOf((double)0.0), SimpleDoubleScore.valueOf((double)1.0)});
    }

    @Test
    public void serializeAndDeserialize() {
        SimpleDoubleScore input = SimpleDoubleScore.valueOf((double)123.4);
        SerializationTestUtils.serializeAndDeserializeWithAll(input, new SerializationTestUtils.OutputAsserter<SimpleDoubleScore>(){

            @Override
            public void assertOutput(SimpleDoubleScore output) {
                Assert.assertEquals((double)123.4, (double)output.getScore(), (double)0.0);
            }
        });
    }
}

