/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SortingValueSelector;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class SortingValueSelectorTest {
    @Test
    public void originalSelectionCacheTypeSolver() {
        this.runOriginalSelection(SelectionCacheType.SOLVER, 1);
    }

    @Test
    public void originalSelectionCacheTypePhase() {
        this.runOriginalSelection(SelectionCacheType.PHASE, 2);
    }

    @Test
    public void originalSelectionCacheTypeStep() {
        this.runOriginalSelection(SelectionCacheType.STEP, 5);
    }

    public void runOriginalSelection(SelectionCacheType cacheType, int timesCalled) {
        EntityIndependentValueSelector childValueSelector = SelectorTestUtils.mockEntityIndependentValueSelector(TestdataEntity.class, "value", new TestdataValue("jan"), new TestdataValue("feb"), new TestdataValue("mar"), new TestdataValue("apr"), new TestdataValue("may"), new TestdataValue("jun"));
        SelectionSorter<TestdataValue> sorter = new SelectionSorter<TestdataValue>(){

            public void sort(ScoreDirector scoreDirector, List<TestdataValue> selectionList) {
                Collections.sort(selectionList, new Comparator<TestdataValue>(){

                    @Override
                    public int compare(TestdataValue a, TestdataValue b) {
                        return a.getCode().compareTo(b.getCode());
                    }
                });
            }
        };
        SortingValueSelector valueSelector = new SortingValueSelector(childValueSelector, cacheType, (SelectionSorter)sorter);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        valueSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "apr", "feb", "jan", "jun", "mar", "may");
        valueSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        valueSelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "apr", "feb", "jan", "jun", "mar", "may");
        valueSelector.stepEnded(stepScopeA2);
        valueSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        valueSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "apr", "feb", "jan", "jun", "mar", "may");
        valueSelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "apr", "feb", "jan", "jun", "mar", "may");
        valueSelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        valueSelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfValueSelector((EntityIndependentValueSelector)valueSelector, "apr", "feb", "jan", "jun", "mar", "may");
        valueSelector.stepEnded(stepScopeB3);
        valueSelector.phaseEnded(phaseScopeB);
        valueSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)childValueSelector, 1, 2, 5);
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)timesCalled))).iterator();
        ((EntityIndependentValueSelector)Mockito.verify((Object)childValueSelector, (VerificationMode)Mockito.times((int)timesCalled))).getSize();
    }
}

