/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PillarChangeMove
implements Move {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final List<Object> pillar;
    protected final Object toPlanningValue;

    public PillarChangeMove(List<Object> pillar, GenuineVariableDescriptor variableDescriptor, Object toPlanningValue) {
        this.pillar = pillar;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    public List<Object> getPillar() {
        return this.pillar;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        return !ObjectUtils.equals((Object)oldValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.pillar.get(0));
        return new PillarChangeMove(this.pillar, this.variableDescriptor, oldValue);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (Object entity : this.pillar) {
            scoreDirector.beforeVariableChanged(this.variableDescriptor, entity);
            this.variableDescriptor.setValue(entity, this.toPlanningValue);
            scoreDirector.afterVariableChanged(this.variableDescriptor, entity);
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.pillar;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PillarChangeMove) {
            PillarChangeMove other = (PillarChangeMove)o;
            return new EqualsBuilder().append((Object)this.variableDescriptor, (Object)other.variableDescriptor).append(this.pillar, other.pillar).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.variableDescriptor).append(this.pillar).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.pillar + " => " + this.toPlanningValue;
    }
}

