/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class BendableBigDecimalScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableBigDecimalScoreHolder scoreHolder = new BendableBigDecimalScoreHolder(constraintMatchEnabled, 1, 2);
        scoreHolder.addHardConstraintMatch(this.createRuleContext("scoreRule1"), 0, BigDecimal.valueOf(-1000L));
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, 0, BigDecimal.valueOf(-200L));
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-30L));
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, BigDecimal.valueOf(-3L));
        scoreHolder.addSoftConstraintMatch(this.createRuleContext("scoreRule4"), 1, BigDecimal.valueOf(-4L));
        Assert.assertEquals((Object)BendableBigDecimalScore.valueOf((BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(-1000L)}, (BigDecimal[])new BigDecimal[]{BigDecimal.valueOf(-3L), BigDecimal.valueOf(-4L)}), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)4L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

