/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity;

import org.junit.Test;
import org.optaplanner.core.config.heuristic.selector.AbstractSelectorConfigTest;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class EntitySelectorConfigTest
extends AbstractSelectorConfigTest {
    @Test
    public void phaseOriginal() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepOriginal() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test
    public void justInTimeOriginal() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.ORIGINAL);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
    }

    @Test
    public void phaseRandom() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepRandom() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
        PlannerAssert.assertNotInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test
    public void justInTimeRandom() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.RANDOM);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, entitySelector);
    }

    @Test
    public void phaseShuffled() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.PHASE);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, ((ShufflingEntitySelector)entitySelector).getChildEntitySelector());
        PlannerAssert.assertEquals((Object)SelectionCacheType.PHASE, (Object)entitySelector.getCacheType());
    }

    @Test
    public void stepShuffled() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.STEP);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
        PlannerAssert.assertInstanceOf(ShufflingEntitySelector.class, entitySelector);
        PlannerAssert.assertInstanceOf(FromSolutionEntitySelector.class, ((ShufflingEntitySelector)entitySelector).getChildEntitySelector());
        PlannerAssert.assertEquals((Object)SelectionCacheType.STEP, (Object)entitySelector.getCacheType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void justInTimeShuffled() {
        EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
        entitySelectorConfig.setCacheType(SelectionCacheType.JUST_IN_TIME);
        entitySelectorConfig.setSelectionOrder(SelectionOrder.SHUFFLED);
        EntitySelector entitySelector = entitySelectorConfig.buildEntitySelector(this.buildHeuristicConfigPolicy(), SelectionCacheType.JUST_IN_TIME, SelectionOrder.RANDOM);
    }
}

