/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.PillarChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;

public class PillarChangeMoveTest {
    @Test
    public void isMoveDoableValueRangeProviderOnEntity() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataValue v4 = new TestdataValue("4");
        TestdataValue v5 = new TestdataValue("5");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        TestdataEntityProvidingEntity b = new TestdataEntityProvidingEntity("b", Arrays.asList(v2, v3, v4, v5), null);
        TestdataEntityProvidingEntity c = new TestdataEntityProvidingEntity("c", Arrays.asList(v4, v5), null);
        TestdataEntityProvidingEntity z = new TestdataEntityProvidingEntity("c", Arrays.asList(v1, v2, v3, v4, v5), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        a.setValue(v2);
        b.setValue(v2);
        PillarChangeMove abMove = new PillarChangeMove(Arrays.asList(a, b), entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v1);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v2);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v3);
        Assert.assertEquals((Object)true, (Object)abMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        b.setValue(v2);
        abMove = new PillarChangeMove(Arrays.asList(a, b), entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v4);
        Assert.assertEquals((Object)false, (Object)abMove.isMoveDoable(scoreDirector));
    }
}

