/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.decider;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.event.ExhaustiveSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhaustiveSearchDecider
implements ExhaustiveSearchPhaseLifecycleListener {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final BestSolutionRecaller bestSolutionRecaller;
    protected final Termination termination;
    protected final ManualEntityMimicRecorder manualEntityMimicRecorder;
    protected final MoveSelector moveSelector;
    protected final boolean scoreBounderEnabled;
    protected final ScoreBounder scoreBounder;
    protected boolean assertMoveScoreFromScratch = false;
    protected boolean assertExpectedUndoMoveScore = false;

    public ExhaustiveSearchDecider(BestSolutionRecaller bestSolutionRecaller, Termination termination, ManualEntityMimicRecorder manualEntityMimicRecorder, MoveSelector moveSelector, boolean scoreBounderEnabled, ScoreBounder scoreBounder) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.termination = termination;
        this.manualEntityMimicRecorder = manualEntityMimicRecorder;
        this.moveSelector = moveSelector;
        this.scoreBounderEnabled = scoreBounderEnabled;
        this.scoreBounder = scoreBounder;
    }

    public ManualEntityMimicRecorder getManualEntityMimicRecorder() {
        return this.manualEntityMimicRecorder;
    }

    public MoveSelector getMoveSelector() {
        return this.moveSelector;
    }

    public boolean isScoreBounderEnabled() {
        return this.scoreBounderEnabled;
    }

    public ScoreBounder getScoreBounder() {
        return this.scoreBounder;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.moveSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope phaseScope) {
        this.moveSelector.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope stepScope) {
        this.moveSelector.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope stepScope) {
        this.moveSelector.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope phaseScope) {
        this.moveSelector.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.moveSelector.solvingEnded(solverScope);
    }

    public void expandNode(ExhaustiveSearchStepScope stepScope) {
        ExhaustiveSearchNode expandingNode = stepScope.getExpandingNode();
        this.manualEntityMimicRecorder.setRecordedEntity(expandingNode.getEntity());
        stepScope.setBestScoreImproved(false);
        int moveIndex = 0;
        ExhaustiveSearchLayer moveLayer = stepScope.getPhaseScope().getLayerList().get(expandingNode.getDepth() + 1);
        for (Move move : this.moveSelector) {
            ExhaustiveSearchNode moveNode = new ExhaustiveSearchNode(moveLayer, expandingNode);
            ++moveIndex;
            moveNode.setMove(move);
            this.doMove(stepScope, moveNode);
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        stepScope.setSelectedMoveCount(Long.valueOf(moveIndex));
    }

    private void doMove(ExhaustiveSearchStepScope stepScope, ExhaustiveSearchNode moveNode) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        Move move = moveNode.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveNode.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(stepScope, moveNode);
        undoMove.doMove(scoreDirector);
        if (this.assertExpectedUndoMoveScore) {
            ExhaustiveSearchPhaseScope phaseScope = stepScope.getPhaseScope();
            phaseScope.assertExpectedUndoMoveScore(move, undoMove);
        }
        this.logger.trace("        Move breadth ({}), score ({}), move ({}).", new Object[]{moveNode.getBreadth(), moveNode.getScore(), moveNode.getMove()});
    }

    private void processMove(ExhaustiveSearchStepScope stepScope, ExhaustiveSearchNode moveNode) {
        ExhaustiveSearchPhaseScope phaseScope = stepScope.getPhaseScope();
        int uninitializedVariableCount = moveNode.getUninitializedVariableCount();
        if (!this.scoreBounderEnabled) {
            if (uninitializedVariableCount == 0) {
                Score score = phaseScope.calculateScore();
                moveNode.setScore(score);
                if (this.assertMoveScoreFromScratch) {
                    phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
                }
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(uninitializedVariableCount, score, stepScope);
            } else {
                phaseScope.getExpandableNodeQueue().add(moveNode);
            }
        } else {
            Score score = phaseScope.calculateScore();
            moveNode.setScore(score);
            if (this.assertMoveScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
            }
            if (uninitializedVariableCount == 0) {
                phaseScope.registerPessimisticBound(score);
                this.bestSolutionRecaller.processWorkingSolutionDuringMove(uninitializedVariableCount, score, stepScope);
            } else {
                Score optimisticBound = this.scoreBounder.calculateOptimisticBound(phaseScope.getScoreDirector(), score, uninitializedVariableCount);
                moveNode.setOptimisticBound(optimisticBound);
                if (optimisticBound.compareTo(phaseScope.getBestPessimisticBound()) > 0) {
                    phaseScope.getExpandableNodeQueue().add(moveNode);
                    Score pessimisticBound = this.scoreBounder.calculatePessimisticBound(phaseScope.getScoreDirector(), score, uninitializedVariableCount);
                    phaseScope.registerPessimisticBound(pessimisticBound);
                }
            }
        }
    }
}

