/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.TimeMillisSpentTermination;

public class TimeMillisSpentTerminationTest {
    @Test
    public void solveTermination() {
        TimeMillisSpentTermination termination = new TimeMillisSpentTermination(1000L);
        DefaultSolverScope phaseScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)0L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)100L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)0.1, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)500L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)0.5, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)700L);
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)0.7, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)1000L);
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculateTimeMillisSpent()).thenReturn((Object)1200L);
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(phaseScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        TimeMillisSpentTermination termination = new TimeMillisSpentTermination(1000L);
        AbstractPhaseScope phaseScope = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)0L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)100L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.1, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)500L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.5, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)700L);
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.7, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)1000L);
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.calculatePhaseTimeMillisSpent()).thenReturn((Object)1200L);
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }
}

