/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.solution.mutation;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public class MutationCounter {
    protected final SolutionDescriptor solutionDescriptor;

    public MutationCounter(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    public int countMutations(Solution a, Solution b) {
        int mutationCount = 0;
        for (EntityDescriptor entityDescriptor : this.solutionDescriptor.getGenuineEntityDescriptors()) {
            List<Object> aEntities = entityDescriptor.extractEntities(a);
            List<Object> bEntities = entityDescriptor.extractEntities(b);
            Iterator<Object> aIt = aEntities.iterator();
            Iterator<Object> bIt = bEntities.iterator();
            while (aIt.hasNext() && bIt.hasNext()) {
                Object aEntity = aIt.next();
                Object bEntity = bIt.next();
                for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                    if (variableDescriptor.getValue(aEntity) == variableDescriptor.getValue(bEntity)) continue;
                    ++mutationCount;
                }
            }
            if (aEntities.size() == bEntities.size()) continue;
            mutationCount += Math.abs(aEntities.size() - bEntities.size()) * entityDescriptor.getGenuineVariableDescriptors().size();
        }
        return mutationCount;
    }
}

