/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.common;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;

public class TrailingEntityMapSupport {
    protected final SolutionDescriptor solutionDescriptor;
    protected boolean hasChainedVariables;
    protected Map<GenuineVariableDescriptor, Map<Object, Set<Object>>> trailingEntitiesMap;

    public TrailingEntityMapSupport(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
        Collection<GenuineVariableDescriptor> chainedVariableDescriptors = solutionDescriptor.getChainedVariableDescriptors();
        this.hasChainedVariables = !chainedVariableDescriptors.isEmpty();
        this.trailingEntitiesMap = new LinkedHashMap<GenuineVariableDescriptor, Map<Object, Set<Object>>>(chainedVariableDescriptors.size());
        for (GenuineVariableDescriptor chainedVariableDescriptor : chainedVariableDescriptors) {
            this.trailingEntitiesMap.put(chainedVariableDescriptor, null);
        }
    }

    public void resetTrailingEntityMap(Solution workingSolution) {
        if (this.hasChainedVariables) {
            List<Object> entityList = this.solutionDescriptor.getEntityList(workingSolution);
            for (Map.Entry<GenuineVariableDescriptor, Map<Object, Set<Object>>> entry : this.trailingEntitiesMap.entrySet()) {
                entry.setValue(new IdentityHashMap(entityList.size()));
            }
            for (Object entity : entityList) {
                this.insertInTrailingEntityMap(this.solutionDescriptor.findEntityDescriptorOrFail(entity.getClass()), entity);
            }
        }
    }

    public void insertInTrailingEntityMap(EntityDescriptor entityDescriptor, Object entity) {
        if (this.hasChainedVariables) {
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                this.insertInTrailingEntityMap(variableDescriptor, entity);
            }
        }
    }

    public void insertInTrailingEntityMap(VariableDescriptor variableDescriptor, Object entity) {
        if (this.hasChainedVariables && variableDescriptor instanceof GenuineVariableDescriptor && ((GenuineVariableDescriptor)variableDescriptor).isChained()) {
            boolean addSucceeded;
            Map<Object, Set<Object>> valueToTrailingEntityMap = this.trailingEntitiesMap.get(variableDescriptor);
            if (valueToTrailingEntityMap == null) {
                throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is bugged," + " because the chained planningVariable (" + variableDescriptor.getVariableName() + ") was not found in the trailingEntitiesMap.");
            }
            Object value = variableDescriptor.getValue(entity);
            Set<Object> trailingEntities = valueToTrailingEntityMap.get(value);
            if (trailingEntities == null) {
                trailingEntities = Collections.newSetFromMap(new IdentityHashMap());
                valueToTrailingEntityMap.put(value, trailingEntities);
            }
            if (!(addSucceeded = trailingEntities.add(entity))) {
                throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is corrupted," + " because the entity (" + entity + ") for chained planningVariable (" + variableDescriptor.getVariableName() + ") cannot be inserted: it was already inserted.");
            }
        }
    }

    public void retractFromTrailingEntityMap(EntityDescriptor entityDescriptor, Object entity) {
        if (this.hasChainedVariables) {
            for (GenuineVariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                this.retractFromTrailingEntityMap(variableDescriptor, entity);
            }
        }
    }

    public void retractFromTrailingEntityMap(VariableDescriptor variableDescriptor, Object entity) {
        if (this.hasChainedVariables && variableDescriptor instanceof GenuineVariableDescriptor && ((GenuineVariableDescriptor)variableDescriptor).isChained()) {
            boolean removeSucceeded;
            Map<Object, Set<Object>> valueToTrailingEntityMap = this.trailingEntitiesMap.get(variableDescriptor);
            if (valueToTrailingEntityMap == null) {
                throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is bugged," + " because the chained planningVariable (" + variableDescriptor.getVariableName() + ") was not found in the trailingEntitiesMap.");
            }
            Object value = variableDescriptor.getValue(entity);
            Set<Object> trailingEntities = valueToTrailingEntityMap.get(value);
            boolean bl = removeSucceeded = trailingEntities != null && trailingEntities.remove(entity);
            if (!removeSucceeded) {
                throw new IllegalStateException("The ScoreDirector (" + this.getClass() + ") is corrupted," + " because the entity (" + entity + ") for chained planningVariable (" + variableDescriptor.getVariableName() + ") cannot be retracted: it was never inserted.");
            }
            if (trailingEntities.isEmpty()) {
                valueToTrailingEntityMap.put(value, null);
            }
        }
    }

    public Object getTrailingEntity(GenuineVariableDescriptor chainedVariableDescriptor, Object planningValue) {
        Set<Object> trailingEntities = this.trailingEntitiesMap.get(chainedVariableDescriptor).get(planningValue);
        if (trailingEntities == null) {
            return null;
        }
        if (trailingEntities.size() > 1) {
            throw new IllegalStateException("The planningValue (" + planningValue + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + chainedVariableDescriptor.getVariableName() + ").");
        }
        return trailingEntities.iterator().next();
    }
}

