/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.decider.forager;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicPickEarlyType;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.DefaultConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;

public class DefaultConstructionHeuristicForagerTest {
    @Test
    public void checkPickEarlyNever() {
        DefaultConstructionHeuristicForager forager = new DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType.NEVER);
        ConstructionHeuristicStepScope stepScope = this.buildStepScope((Score)SimpleScore.valueOf((int)-100));
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-110)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-100)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-90)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
    }

    @Test
    public void checkPickEarlyFirstNonDeterioratingScore() {
        DefaultConstructionHeuristicForager forager = new DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType.FIRST_NON_DETERIORATING_SCORE);
        ConstructionHeuristicStepScope stepScope = this.buildStepScope((Score)SimpleScore.valueOf((int)-100));
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-110)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)SimpleScore.valueOf((int)-100)));
        Assert.assertEquals((Object)true, (Object)forager.isQuitEarly());
    }

    @Test
    public void checkPickEarlyFirstFeasibleScore() {
        DefaultConstructionHeuristicForager forager = new DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType.FIRST_FEASIBLE_SCORE);
        ConstructionHeuristicStepScope stepScope = this.buildStepScope((Score)HardSoftScore.valueOf((int)0, (int)-100));
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)-1, (int)-110)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)-1, (int)-90)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)0, (int)-110)));
        Assert.assertEquals((Object)true, (Object)forager.isQuitEarly());
    }

    @Test
    public void checkPickEarlyFirstFeasibleScoreOrNonDeterioratingHard() {
        DefaultConstructionHeuristicForager forager = new DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType.FIRST_FEASIBLE_SCORE_OR_NON_DETERIORATING_HARD);
        ConstructionHeuristicStepScope stepScope = this.buildStepScope((Score)HardSoftScore.valueOf((int)-10, (int)-100));
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)-11, (int)-110)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)-11, (int)-90)));
        Assert.assertEquals((Object)false, (Object)forager.isQuitEarly());
        forager.checkPickEarly(this.buildMoveScope(stepScope, (Score)HardSoftScore.valueOf((int)-10, (int)-110)));
        Assert.assertEquals((Object)true, (Object)forager.isQuitEarly());
    }

    protected ConstructionHeuristicStepScope buildStepScope(Score lastStepScore) {
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        ConstructionHeuristicStepScope lastCompletedStepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)lastCompletedStepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Mockito.when((Object)lastCompletedStepScope.getScore()).thenReturn((Object)lastStepScore);
        Mockito.when((Object)phaseScope.getLastCompletedStepScope()).thenReturn((Object)lastCompletedStepScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        return stepScope;
    }

    protected ConstructionHeuristicMoveScope buildMoveScope(ConstructionHeuristicStepScope stepScope, Score score) {
        ConstructionHeuristicMoveScope moveScope = (ConstructionHeuristicMoveScope)Mockito.mock(ConstructionHeuristicMoveScope.class);
        Mockito.when((Object)moveScope.getStepScope()).thenReturn((Object)stepScope);
        Mockito.when((Object)moveScope.getScore()).thenReturn((Object)score);
        return moveScope;
    }
}

