/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager.finalist;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.StrategicOscillationByLevelFinalistPodium;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class StrategicOscillationByLevelFinalistPodiumTest {
    @Test
    public void referenceLastStepScore() {
        StrategicOscillationByLevelFinalistPodium finalistPodium = new StrategicOscillationByLevelFinalistPodium(false);
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)HardSoftScore.valueOf((int)-200, (int)-5000));
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore(solverScope.getBestScore());
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        finalistPodium.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope0);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -100, -7000);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -150, -2000));
        finalistPodium.addMove(moveScope0);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -100, -7100));
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -200, -1000));
        Assert.assertSame((Object)moveScope0, (Object)finalistPodium.pickMove(stepScope0));
        stepScope0.setScore(moveScope0.getScore());
        finalistPodium.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope1);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -120, -4000);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -8000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -7000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -3000));
        finalistPodium.addMove(moveScope1);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -2000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -200, -1000));
        Assert.assertSame((Object)moveScope1, (Object)finalistPodium.pickMove(stepScope1));
        stepScope1.setScore(moveScope1.getScore());
        finalistPodium.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope2);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope2, -150, -1000);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -120, -4000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -120, -5000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -3000));
        finalistPodium.addMove(moveScope2);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -2000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -160, -500));
        Assert.assertSame((Object)moveScope2, (Object)finalistPodium.pickMove(stepScope2));
        stepScope2.setScore(moveScope2.getScore());
        finalistPodium.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
    }

    @Test
    public void referenceBestScore() {
        StrategicOscillationByLevelFinalistPodium finalistPodium = new StrategicOscillationByLevelFinalistPodium(true);
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)HardSoftScore.valueOf((int)-200, (int)-5000));
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore(solverScope.getBestScore());
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        finalistPodium.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope0);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -100, -7000);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -150, -2000));
        finalistPodium.addMove(moveScope0);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -100, -7100));
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -200, -1000));
        Assert.assertSame((Object)moveScope0, (Object)finalistPodium.pickMove(stepScope0));
        stepScope0.setScore(moveScope0.getScore());
        finalistPodium.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        solverScope.setBestScore(stepScope0.getScore());
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope1);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -120, -4000);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -8000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -7000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -3000));
        finalistPodium.addMove(moveScope1);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -2000));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -200, -1000));
        Assert.assertSame((Object)moveScope1, (Object)finalistPodium.pickMove(stepScope1));
        stepScope1.setScore(moveScope1.getScore());
        finalistPodium.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope2);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope2, -110, -6000);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -110, -8000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -3000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -1000));
        finalistPodium.addMove(moveScope2);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -2000));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -160, -500));
        Assert.assertSame((Object)moveScope2, (Object)finalistPodium.pickMove(stepScope2));
        stepScope2.setScore(moveScope2.getScore());
        finalistPodium.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
    }

    protected LocalSearchMoveScope buildMoveScope(LocalSearchStepScope stepScope, int hardScore, int softScore) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        Move move = (Move)Mockito.mock(Move.class);
        moveScope.setAccepted(Boolean.valueOf(true));
        moveScope.setMove(move);
        moveScope.setScore((Score)HardSoftScore.valueOf((int)hardScore, (int)softScore));
        return moveScope;
    }

    @Test
    public void referenceLastStepScore3Levels() {
        StrategicOscillationByLevelFinalistPodium finalistPodium = new StrategicOscillationByLevelFinalistPodium(false);
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)HardMediumSoftScore.valueOf((int)-200, (int)-5000, (int)-10));
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore(solverScope.getBestScore());
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        finalistPodium.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope0);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -100, -7000, -20);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -150, -2000, -10));
        finalistPodium.addMove(moveScope0);
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -100, -7100, -5));
        finalistPodium.addMove(this.buildMoveScope(stepScope0, -200, -1000, -10));
        Assert.assertSame((Object)moveScope0, (Object)finalistPodium.pickMove(stepScope0));
        stepScope0.setScore(moveScope0.getScore());
        finalistPodium.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope1);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -120, -4000, -40);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -8000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -100, -7000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -3000, -10));
        finalistPodium.addMove(moveScope1);
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -150, -2000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope1, -200, -1000, -10));
        Assert.assertSame((Object)moveScope1, (Object)finalistPodium.pickMove(stepScope1));
        stepScope1.setScore(moveScope1.getScore());
        finalistPodium.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        finalistPodium.stepStarted(stepScope2);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope2, -150, -1000, -20);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -120, -4000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -120, -5000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -3000, -10));
        finalistPodium.addMove(moveScope2);
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -150, -2000, -10));
        finalistPodium.addMove(this.buildMoveScope(stepScope2, -160, -500, -10));
        Assert.assertSame((Object)moveScope2, (Object)finalistPodium.pickMove(stepScope2));
        stepScope2.setScore(moveScope2.getScore());
        finalistPodium.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
    }

    protected LocalSearchMoveScope buildMoveScope(LocalSearchStepScope stepScope, int hardScore, int mediumScore, int softScore) {
        LocalSearchMoveScope moveScope = new LocalSearchMoveScope(stepScope);
        Move move = (Move)Mockito.mock(Move.class);
        moveScope.setAccepted(Boolean.valueOf(true));
        moveScope.setMove(move);
        moveScope.setScore((Score)HardMediumSoftScore.valueOf((int)hardScore, (int)mediumScore, (int)softScore));
        return moveScope;
    }
}

