/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Comparator;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSorterManner;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.CachingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.DowncastingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityDependentSortingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ProbabilityValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SelectedCountLimitValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.SortingValueSelector;

@XStreamAlias(value="valueSelector")
public class ValueSelectorConfig
extends SelectorConfig {
    protected Class<?> downcastEntityClass = null;
    protected String variableName = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamAlias(value="nearbySelection")
    protected NearbySelectionConfig nearbySelectionConfig = null;
    protected ValueSorterManner sorterManner = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected Long selectedCountLimit = null;

    public Class<?> getDowncastEntityClass() {
        return this.downcastEntityClass;
    }

    public void setDowncastEntityClass(Class<?> downcastEntityClass) {
        this.downcastEntityClass = downcastEntityClass;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public ValueSorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(ValueSorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    public Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public ValueSelector buildValueSelector(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        entityDescriptor = this.downcastEntityDescriptor(configPolicy, entityDescriptor);
        GenuineVariableDescriptor variableDescriptor = this.deduceVariableDescriptor(entityDescriptor, this.variableName);
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        ValueSelector valueSelector = this.buildBaseValueSelector(configPolicy, variableDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(variableDescriptor, resolvedCacheType, resolvedSelectionOrder));
        if (this.nearbySelectionConfig != null) {
            valueSelector = this.nearbySelectionConfig.applyNearbyValueSelector(configPolicy, minimumCacheType, resolvedCacheType, resolvedSelectionOrder, valueSelector);
        }
        valueSelector = this.applyInitializedChainedValueFilter(configPolicy, variableDescriptor, resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySelectedLimit(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyReinitializeVariableFiltering(configPolicy, valueSelector);
        valueSelector = this.applyDowncasting(configPolicy, valueSelector);
        return valueSelector;
    }

    protected EntityDescriptor downcastEntityDescriptor(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor) {
        if (this.downcastEntityClass != null) {
            Class<?> parentEntityClass = entityDescriptor.getEntityClass();
            if (!parentEntityClass.isAssignableFrom(this.downcastEntityClass)) {
                throw new IllegalStateException("The downcastEntityClass (" + this.downcastEntityClass + ") is not a subclass of the parentEntityClass (" + parentEntityClass + ") configured by the " + EntitySelector.class.getSimpleName() + ".");
            }
            SolutionDescriptor solutionDescriptor = configPolicy.getSolutionDescriptor();
            entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(this.downcastEntityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (" + this + ") has an downcastEntityClass (" + this.downcastEntityClass + ") that is not a known planning entity.\n" + "Check your solver configuration. If that class (" + this.downcastEntityClass.getSimpleName() + ") is not in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), check your Solution implementation's annotated methods too.");
            }
        }
        return entityDescriptor;
    }

    protected boolean determineBaseRandomSelection(GenuineVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached(variableDescriptor) && !this.hasFiltering();
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached(GenuineVariableDescriptor variableDescriptor) {
        return variableDescriptor.isValueRangeEntityIndependent();
    }

    private ValueSelector buildBaseValueSelector(HeuristicConfigPolicy configPolicy, GenuineVariableDescriptor variableDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + (Object)((Object)minimumCacheType) + ") is not yet supported. Please use " + (Object)((Object)SelectionCacheType.PHASE) + " instead.");
        }
        if (valueRangeDescriptor.isEntityIndependent()) {
            return new FromSolutionPropertyValueSelector((EntityIndependentValueRangeDescriptor)valueRangeDescriptor, minimumCacheType, randomSelection);
        }
        return new FromEntityPropertyValueSelector(valueRangeDescriptor, randomSelection);
    }

    private boolean hasFiltering() {
        return false;
    }

    protected ValueSelector applyInitializedChainedValueFilter(HeuristicConfigPolicy configPolicy, GenuineVariableDescriptor variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (configPolicy.isInitializedChainedValueFilterEnabled() && variableDescriptor.isChained()) {
            valueSelector = new InitializedValueSelector(valueSelector);
        }
        return valueSelector;
    }

    private void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((this.sorterManner != null || this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") and sorterComparatorClass (" + this.sorterComparatorClass + ") and sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and sorterOrder (" + (Object)((Object)this.sorterOrder) + ") and sorterClass (" + this.sorterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.SORTED) + ".");
        }
        if (this.sorterManner != null && this.sorterComparatorClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterComparatorClass (" + this.sorterComparatorClass + ").");
        }
        if (this.sorterManner != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterManner != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterManner (" + (Object)((Object)this.sorterManner) + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterManner != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterManner (" + (Object)((Object)this.sorterManner) + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterWeightFactoryClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") has both a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterClass != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with sorterClass (" + this.sorterClass + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
    }

    private ValueSelector applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            WeightFactorySelectionSorter sorter;
            if (this.sorterManner != null) {
                GenuineVariableDescriptor variableDescriptor = valueSelector.getVariableDescriptor();
                if (!this.sorterManner.hasSorter(variableDescriptor)) {
                    return valueSelector;
                }
                sorter = this.sorterManner.determineSorter(variableDescriptor);
            } else if (this.sorterComparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this, "sorterComparatorClass", this.sorterComparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterWeightFactoryClass != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this, "sorterWeightFactoryClass", this.sorterWeightFactoryClass);
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterClass != null) {
                sorter = ConfigUtils.newInstance(this, "sorterClass", this.sorterClass);
            } else {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a sorterManner (" + (Object)((Object)this.sorterManner) + ") or a sorterComparatorClass (" + this.sorterComparatorClass + ") or a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") or a sorterClass (" + this.sorterClass + ").");
            }
            if (!valueSelector.getVariableDescriptor().isValueRangeEntityIndependent() && resolvedCacheType == SelectionCacheType.STEP) {
                valueSelector = new EntityDependentSortingValueSelector(valueSelector, resolvedCacheType, sorter);
            } else {
                if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                    throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
                }
                valueSelector = new SortingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, sorter);
            }
        }
        return valueSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (this.probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    private ValueSelector applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (this.probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this, "probabilityWeightFactoryClass", this.probabilityWeightFactoryClass);
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ProbabilityValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return valueSelector;
    }

    private ValueSelector applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ShufflingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType);
        }
        return valueSelector;
    }

    private ValueSelector applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(valueSelector.getCacheType()) > 0) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") and resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs to be based on a EntityIndependentValueSelector (" + valueSelector + ")." + " Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new CachingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return valueSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (this.selectedCountLimit != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this + ") with selectedCountLimit (" + this.selectedCountLimit + ") has a minimumCacheType (" + (Object)((Object)minimumCacheType) + ") that is higher than " + (Object)((Object)SelectionCacheType.JUST_IN_TIME) + ".");
        }
    }

    private ValueSelector applySelectedLimit(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        if (this.selectedCountLimit != null) {
            valueSelector = new SelectedCountLimitValueSelector(valueSelector, this.selectedCountLimit);
        }
        return valueSelector;
    }

    private ValueSelector applyReinitializeVariableFiltering(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (configPolicy.isReinitializeVariableFilterEnabled()) {
            valueSelector = new ReinitializeVariableValueSelector(valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector applyDowncasting(HeuristicConfigPolicy configPolicy, ValueSelector valueSelector) {
        if (this.downcastEntityClass != null) {
            valueSelector = new DowncastingValueSelector(valueSelector, this.downcastEntityClass);
        }
        return valueSelector;
    }

    public void inherit(ValueSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.downcastEntityClass = ConfigUtils.inheritOverwritableProperty(this.downcastEntityClass, inheritedConfig.getDowncastEntityClass());
        this.variableName = ConfigUtils.inheritOverwritableProperty(this.variableName, inheritedConfig.getVariableName());
        if (this.nearbySelectionConfig == null) {
            this.nearbySelectionConfig = inheritedConfig.getNearbySelectionConfig();
        } else if (inheritedConfig.getNearbySelectionConfig() != null) {
            this.nearbySelectionConfig.inherit(inheritedConfig.getNearbySelectionConfig());
        }
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + ")";
    }
}

