/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.composite;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.composite.NullableCountableValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class NullableCountableValueRangeTest {
    @Test
    public void getSize() {
        Assert.assertEquals((long)5L, (long)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).getSize());
        Assert.assertEquals((long)6L, (long)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8))).getSize());
        Assert.assertEquals((long)4L, (long)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(-15, 25, 0))).getSize());
        Assert.assertEquals((long)4L, (long)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).getSize());
        Assert.assertEquals((long)1L, (long)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Collections.emptyList())).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((long)5L, (long)((Integer)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).get(2L)).intValue());
        Assert.assertEquals(null, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).get(4L));
        Assert.assertEquals((Object)"c", (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a", "c", "g", "d"))).get(3L));
        Assert.assertEquals(null, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a", "c", "g", "d"))).get(6L));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).contains((Object)5));
        Assert.assertEquals((Object)false, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).contains((Object)4));
        Assert.assertEquals((Object)true, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).contains(null));
        Assert.assertEquals((Object)true, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).contains((Object)"a"));
        Assert.assertEquals((Object)false, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).contains((Object)"n"));
        Assert.assertEquals((Object)true, (Object)new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).contains(null));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5, 10))).createOriginalIterator(), 0, 2, 5, 10, null);
        PlannerAssert.assertAllElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(100, 120, 5, 7, 8))).createOriginalIterator(), 100, 120, 5, 7, 8, null);
        PlannerAssert.assertAllElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(-15, 25, 0))).createOriginalIterator(), -15, 25, 0, null);
        PlannerAssert.assertAllElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).createOriginalIterator(), "b", "z", "a", null);
        PlannerAssert.assertAllElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Collections.emptyList())).createOriginalIterator(), new String[]{null});
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(0, 2, 5))).createRandomIterator(workingRandom), null, 0);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(100, 120, 5))).createRandomIterator(workingRandom), null, 100);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList(-15, 25, 0))).createRandomIterator(workingRandom), null, -15);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Arrays.asList("b", "z", "a"))).createRandomIterator(workingRandom), null, "b");
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)0);
        PlannerAssert.assertElementsOfIterator(new NullableCountableValueRange((CountableValueRange)new ListValueRange(Collections.emptyList())).createRandomIterator(workingRandom), new String[]{null});
    }
}

