/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.mappedby.TestdataMappedByChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.mappedby.TestdataMappedByChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.mappedby.TestdataMappedByChainedObject;
import org.optaplanner.core.impl.testdata.domain.chained.mappedby.TestdataMappedByChainedSolution;

public class SingletonInverseVariableListenerTest {
    @Test
    public void chained() {
        SolutionDescriptor solutionDescriptor = TestdataMappedByChainedSolution.buildSolutionDescriptor();
        ShadowVariableDescriptor nextEntityVariableDescriptor = solutionDescriptor.findEntityDescriptorOrFail(TestdataMappedByChainedObject.class).getShadowVariableDescriptor("nextEntity");
        SingletonInverseVariableListener variableListener = new SingletonInverseVariableListener(nextEntityVariableDescriptor, (VariableDescriptor)solutionDescriptor.findEntityDescriptorOrFail(TestdataMappedByChainedEntity.class).getGenuineVariableDescriptor("chainedObject"));
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        TestdataMappedByChainedAnchor a0 = new TestdataMappedByChainedAnchor("a0");
        TestdataMappedByChainedEntity a1 = new TestdataMappedByChainedEntity("a1", a0);
        a0.setNextEntity(a1);
        TestdataMappedByChainedEntity a2 = new TestdataMappedByChainedEntity("a2", a1);
        a1.setNextEntity(a2);
        TestdataMappedByChainedEntity a3 = new TestdataMappedByChainedEntity("a3", a2);
        a2.setNextEntity(a3);
        TestdataMappedByChainedAnchor b0 = new TestdataMappedByChainedAnchor("b0");
        TestdataMappedByChainedEntity b1 = new TestdataMappedByChainedEntity("b1", b0);
        b0.setNextEntity(b1);
        TestdataMappedByChainedSolution solution = new TestdataMappedByChainedSolution("solution");
        List<TestdataMappedByChainedAnchor> anchorList = Arrays.asList(a0, b0);
        solution.setChainedAnchorList(anchorList);
        List<TestdataMappedByChainedEntity> originalEntityList = Arrays.asList(a1, a2, a3, b1);
        solution.setChainedEntityList(originalEntityList);
        Assert.assertEquals(null, (Object)b1.getNextEntity());
        variableListener.beforeVariableChanged(scoreDirector, (Object)a3);
        a3.setChainedObject(b1);
        variableListener.afterVariableChanged(scoreDirector, (Object)a3);
        Assert.assertEquals((Object)a3, (Object)b1.getNextEntity());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{scoreDirector});
        ((ScoreDirector)inOrder.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)nextEntityVariableDescriptor, (Object)b1);
        ((ScoreDirector)inOrder.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)nextEntityVariableDescriptor, (Object)b1);
        inOrder.verifyNoMoreInteractions();
    }
}

