/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.move;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.heuristic.move.CompositeMove;
import org.optaplanner.core.impl.heuristic.move.DummyMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.move.NoChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CompositeMoveTest {
    @Test
    public void createUndoMove() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        DummyMove a = new DummyMove("a");
        DummyMove b = new DummyMove("b");
        DummyMove c = new DummyMove("c");
        CompositeMove move = new CompositeMove(new Move[]{a, b, c});
        CompositeMove undoMove = move.createUndoMove(scoreDirector);
        PlannerAssert.assertAllCodesOfArray(move.getMoves(), "a", "b", "c");
        PlannerAssert.assertAllCodesOfArray(undoMove.getMoves(), "undo c", "undo b", "undo a");
    }

    @Test
    public void doMove() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        Move a = (Move)Mockito.mock(Move.class);
        Move b = (Move)Mockito.mock(Move.class);
        Move c = (Move)Mockito.mock(Move.class);
        CompositeMove move = new CompositeMove(new Move[]{a, b, c});
        move.doMove(scoreDirector);
        ((Move)Mockito.verify((Object)a, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
        ((Move)Mockito.verify((Object)b, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
        ((Move)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).doMove(scoreDirector);
    }

    @Test
    public void buildEmptyMove() {
        PlannerAssert.assertInstanceOf(NoChangeMove.class, CompositeMove.buildMove(new ArrayList()));
        PlannerAssert.assertInstanceOf(NoChangeMove.class, CompositeMove.buildMove((Move[])new Move[0]));
    }

    @Test
    public void buildOneElemMove() {
        DummyMove tmpMove = new DummyMove();
        Move move = CompositeMove.buildMove(Collections.singletonList(tmpMove));
        PlannerAssert.assertInstanceOf(DummyMove.class, move);
        move = CompositeMove.buildMove((Move[])new Move[]{tmpMove});
        PlannerAssert.assertInstanceOf(DummyMove.class, move);
    }

    @Test
    public void buildTwoElemMove() {
        DummyMove first = new DummyMove();
        NoChangeMove second = new NoChangeMove();
        Move move = CompositeMove.buildMove(Arrays.asList(first, second));
        PlannerAssert.assertInstanceOf(CompositeMove.class, move);
        PlannerAssert.assertInstanceOf(DummyMove.class, ((CompositeMove)move).getMoves()[0]);
        PlannerAssert.assertInstanceOf(NoChangeMove.class, ((CompositeMove)move).getMoves()[1]);
        move = CompositeMove.buildMove((Move[])new Move[]{first, second});
        PlannerAssert.assertInstanceOf(CompositeMove.class, move);
        PlannerAssert.assertInstanceOf(DummyMove.class, ((CompositeMove)move).getMoves()[0]);
        PlannerAssert.assertInstanceOf(NoChangeMove.class, ((CompositeMove)move).getMoves()[1]);
    }

    @Test
    public void isMoveDoable() {
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        DummyMove first = new DummyMove();
        Move second = (Move)Mockito.mock(DummyMove.class);
        Mockito.when((Object)second.isMoveDoable(scoreDirector)).thenReturn((Object)false);
        Move move = CompositeMove.buildMove((Move[])new Move[]{first, second});
        PlannerAssert.assertEquals((Object)false, (Object)move.isMoveDoable(scoreDirector));
    }

    @Test
    public void equals() {
        DummyMove first = new DummyMove();
        NoChangeMove second = new NoChangeMove();
        Move move = CompositeMove.buildMove(Arrays.asList(first, second));
        Move other = CompositeMove.buildMove(Arrays.asList(first, second));
        PlannerAssert.assertTrue((boolean)move.equals(other));
        move = CompositeMove.buildMove(Arrays.asList(first, second));
        other = CompositeMove.buildMove(Arrays.asList(second, first));
        PlannerAssert.assertFalse((boolean)move.equals(other));
        PlannerAssert.assertFalse((boolean)move.equals(new DummyMove()));
        PlannerAssert.assertTrue((boolean)move.equals(move));
    }
}

