/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BlockDistributionNearbyRandom;

public class BlockDistributionNearbyRandomTest {
    @Test(expected=IllegalArgumentException.class)
    public void sizeMinimumTooLow() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(-10, 300, 0.2, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sizeMaximumTooLow() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 8, 0.2, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sizeRatioTooLow() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 300, -0.2, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void sizeRatioTooHigh() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 300, 1.2, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void uniformDistributionProbabilityTooLow() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 300, 0.2, 1.3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void uniformDistributionProbabilityTooHigh() {
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 300, 0.2, -0.3);
    }

    @Test
    public void nextInt() {
        Random random = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)random.nextInt(Mockito.anyInt())).thenReturn((Object)0, (Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        BlockDistributionNearbyRandom nearbyRandom = new BlockDistributionNearbyRandom(10, 300, 0.2, 0.0);
        Assert.assertEquals((long)0L, (long)nearbyRandom.nextInt(random, 100));
        ((Random)Mockito.verify((Object)random)).nextInt(20);
        Assert.assertEquals((long)1L, (long)nearbyRandom.nextInt(random, 1000));
        ((Random)Mockito.verify((Object)random)).nextInt(200);
        Assert.assertEquals((long)2L, (long)nearbyRandom.nextInt(random, 10000));
        ((Random)Mockito.verify((Object)random)).nextInt(300);
        Assert.assertEquals((long)3L, (long)nearbyRandom.nextInt(random, 20));
        ((Random)Mockito.verify((Object)random)).nextInt(10);
        Assert.assertEquals((long)4L, (long)nearbyRandom.nextInt(random, 7));
        ((Random)Mockito.verify((Object)random)).nextInt(7);
        nearbyRandom = new BlockDistributionNearbyRandom(100, 250, 1.0, 0.0);
        Assert.assertEquals((long)5L, (long)nearbyRandom.nextInt(random, 700));
        ((Random)Mockito.verify((Object)random)).nextInt(250);
        Assert.assertEquals((long)6L, (long)nearbyRandom.nextInt(random, 170));
        ((Random)Mockito.verify((Object)random)).nextInt(170);
        Assert.assertEquals((long)7L, (long)nearbyRandom.nextInt(random, 70));
        ((Random)Mockito.verify((Object)random)).nextInt(70);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.3);
        nearbyRandom = new BlockDistributionNearbyRandom(100, 500, 0.5, 0.4);
        Assert.assertEquals((long)8L, (long)nearbyRandom.nextInt(random, 700));
        ((Random)Mockito.verify((Object)random)).nextInt(700);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.5);
        Assert.assertEquals((long)9L, (long)nearbyRandom.nextInt(random, 700));
        ((Random)Mockito.verify((Object)random)).nextInt(350);
    }
}

