/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.decorator;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.decorator.NullValueReinitializeVariableEntityFilter;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.nullable.TestdataNullableEntity;

public class NullValueReinitializeVariableEntityFilterTest {
    @Test
    public void accept() {
        EntityDescriptor entityDescriptor = TestdataEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("value");
        NullValueReinitializeVariableEntityFilter filter = new NullValueReinitializeVariableEntityFilter(variableDescriptor);
        Assert.assertEquals((Object)false, (Object)filter.accept(null, (Object)new TestdataEntity("a", new TestdataValue())));
        Assert.assertEquals((Object)true, (Object)filter.accept(null, (Object)new TestdataEntity("b", null)));
    }

    @Test
    public void acceptWithNullableEntity() {
        EntityDescriptor entityDescriptor = TestdataNullableEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("value");
        NullValueReinitializeVariableEntityFilter filter = new NullValueReinitializeVariableEntityFilter(variableDescriptor);
        Assert.assertEquals((Object)false, (Object)filter.accept(null, (Object)new TestdataNullableEntity("a", new TestdataValue())));
        Assert.assertEquals((Object)true, (Object)filter.accept(null, (Object)new TestdataNullableEntity("b", null)));
    }
}

