/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;

public class ChangeMoveTest {
    @Test
    public void isMoveDoable() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        ChangeMove aMove = new ChangeMove((Object)a, entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v2);
        a.setValue(v1);
        Assert.assertEquals((Object)true, (Object)aMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        Assert.assertEquals((Object)false, (Object)aMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        Assert.assertEquals((Object)true, (Object)aMove.isMoveDoable(scoreDirector));
    }

    @Test
    public void doMove() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        ChangeMove aMove = new ChangeMove((Object)a, entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v2);
        a.setValue(v1);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        a.setValue(v2);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        a.setValue(v3);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
    }
}

