/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.SubChainReversingChangeMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;

public class SubChainReversingChangeMoveTest {
    @Test
    public void noTrailing() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainReversingChangeMove move = new SubChainReversingChangeMove(new SubChain(Arrays.asList(a3, a4, a5)), variableDescriptor, (Object)b1);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2);
        SelectorTestUtils.assertChain(b0, b1, a5, a4, a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void noTrailingInPlace() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5});
        SubChainReversingChangeMove move = new SubChainReversingChangeMove(new SubChain(Arrays.asList(a3, a4, a5)), variableDescriptor, (Object)a2);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a5, a4, a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
    }

    @Test
    public void oldAndNewTrailing() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5, b1});
        SubChainReversingChangeMove move = new SubChainReversingChangeMove(new SubChain(Arrays.asList(a2, a3, a4)), variableDescriptor, (Object)b0);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a5);
        SelectorTestUtils.assertChain(b0, a4, a3, a2, b1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)b1);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)b1);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void oldAndNewTrailingInPlace() {
        EntityDescriptor entityDescriptor = TestdataChainedEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("chainedObject");
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        SelectorTestUtils.mockMethodGetTrailingEntity(scoreDirector, variableDescriptor, new TestdataChainedEntity[]{a1, a2, a3, a4, a5});
        SubChainReversingChangeMove move = new SubChainReversingChangeMove(new SubChain(Arrays.asList(a2, a3, a4)), variableDescriptor, (Object)a1);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4, a3, a2, a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeast((int)1))).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector, (VerificationMode)Mockito.atLeast((int)1))).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a5);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a4);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a3);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).beforeVariableChanged((VariableDescriptor)variableDescriptor, (Object)a2);
        ((InnerScoreDirector)Mockito.verify((Object)scoreDirector)).afterVariableChanged((VariableDescriptor)variableDescriptor, (Object)a2);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
    }
}

