/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.easy;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirector;
import org.optaplanner.core.impl.score.director.easy.EasyScoreDirectorFactory;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public class EasyScoreDirectorFactoryTest {
    @Test
    public void getEasyScoreCalculator() {
        EasyScoreCalculator scoreCalculator = (EasyScoreCalculator)Mockito.mock(EasyScoreCalculator.class);
        EasyScoreDirectorFactory directorFactory = new EasyScoreDirectorFactory(scoreCalculator);
        Assert.assertSame((Object)scoreCalculator, (Object)directorFactory.getEasyScoreCalculator());
    }

    @Test
    public void buildScoreDirector() {
        SolutionDescriptor solutionDescriptor = TestdataSolution.buildSolutionDescriptor();
        EasyScoreCalculator scoreCalculator = (EasyScoreCalculator)Mockito.mock(EasyScoreCalculator.class);
        Mockito.when((Object)scoreCalculator.calculateScore((Solution)Mockito.any(TestdataSolution.class))).thenReturn((Object)SimpleScore.valueOf((int)-10));
        EasyScoreDirectorFactory directorFactory = new EasyScoreDirectorFactory(scoreCalculator);
        directorFactory.setSolutionDescriptor(solutionDescriptor);
        EasyScoreDirector director = directorFactory.buildScoreDirector(false);
        director.setWorkingSolution((Solution)new TestdataSolution());
        Assert.assertEquals((Object)SimpleScore.valueOf((int)-10), (Object)director.calculateScore());
    }
}

