/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.recaller;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class BestSolutionRecallerTest {
    @Test
    public void unimprovedUninitializedProcessWorkingSolutionDuringStep() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score = SimpleScore.parseScore((String)"0");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score);
        Mockito.when((Object)stepScope.createOrGetClonedSolution()).thenReturn((Object)solution);
        Mockito.when((Object)stepScope.getUninitializedVariableCount()).thenReturn((Object)2);
        solverScope.setBestUninitializedVariableCount(1);
        recaller.processWorkingSolutionDuringStep((AbstractStepScope)stepScope);
        Assert.assertEquals(null, (Object)solverScope.getBestSolution());
        Assert.assertEquals(null, (Object)solverScope.getBestScore());
        Assert.assertEquals((long)1L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void unimprovedInitializedProcessWorkingSolutionDuringStep() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score = SimpleScore.parseScore((String)"0");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score);
        solverScope.setBestSolution(solution);
        solverScope.setBestScore((Score)score);
        Solution solution2 = (Solution)Mockito.mock(Solution.class);
        SimpleScore score2 = SimpleScore.parseScore((String)"-1");
        Mockito.when((Object)solution2.getScore()).thenReturn((Object)score2);
        Mockito.when((Object)stepScope.createOrGetClonedSolution()).thenReturn((Object)solution2);
        Mockito.when((Object)stepScope.getScore()).thenReturn((Object)score2);
        Mockito.when((Object)stepScope.getUninitializedVariableCount()).thenReturn((Object)0);
        solverScope.setBestUninitializedVariableCount(0);
        recaller.processWorkingSolutionDuringStep((AbstractStepScope)stepScope);
        Assert.assertEquals((Object)solution, (Object)solverScope.getBestSolution());
        Assert.assertEquals((Object)score, (Object)solverScope.getBestScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void improvedUninitializedProcessWorkingSolutionDurintStep() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score = SimpleScore.parseScore((String)"0");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score);
        Mockito.when((Object)stepScope.createOrGetClonedSolution()).thenReturn((Object)solution);
        Mockito.when((Object)stepScope.getUninitializedVariableCount()).thenReturn((Object)1);
        solverScope.setBestUninitializedVariableCount(2);
        recaller.processWorkingSolutionDuringStep((AbstractStepScope)stepScope);
        Assert.assertEquals((Object)solution, (Object)solverScope.getBestSolution());
        Assert.assertEquals((Object)score, (Object)solverScope.getBestScore());
        Assert.assertEquals((long)1L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void improvedInitializedProcessWorkingSolutionDuringStep() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score = SimpleScore.parseScore((String)"-1");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score);
        solverScope.setBestSolution(solution);
        solverScope.setBestScore((Score)score);
        Solution solution2 = (Solution)Mockito.mock(Solution.class);
        SimpleScore score2 = SimpleScore.parseScore((String)"0");
        Mockito.when((Object)solution2.getScore()).thenReturn((Object)score2);
        Mockito.when((Object)stepScope.getScore()).thenReturn((Object)score2);
        Mockito.when((Object)stepScope.createOrGetClonedSolution()).thenReturn((Object)solution2);
        Mockito.when((Object)stepScope.getUninitializedVariableCount()).thenReturn((Object)0);
        solverScope.setBestUninitializedVariableCount(0);
        recaller.processWorkingSolutionDuringStep((AbstractStepScope)stepScope);
        Assert.assertEquals((Object)solution2, (Object)solverScope.getBestSolution());
        Assert.assertEquals((Object)score2, (Object)solverScope.getBestScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void unimprovedUninitializedProcessWorkingSolutionDuringMove() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        SimpleScore score = SimpleScore.parseScore((String)"-1");
        solverScope.setBestUninitializedVariableCount(0);
        recaller.processWorkingSolutionDuringMove(1, (Score)score, (AbstractStepScope)stepScope);
        Assert.assertEquals(null, (Object)solverScope.getBestSolution());
        Assert.assertEquals(null, (Object)solverScope.getBestScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void unimprovedInitializedProcessWorkingSolutionDuringMove() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score2 = SimpleScore.parseScore((String)"0");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score2);
        solverScope.setBestScore((Score)score2);
        solverScope.setBestSolution(solution);
        SimpleScore score = SimpleScore.parseScore((String)"-1");
        solverScope.setBestUninitializedVariableCount(0);
        recaller.processWorkingSolutionDuringMove(0, (Score)score, (AbstractStepScope)stepScope);
        Assert.assertEquals((Object)solution, (Object)solverScope.getBestSolution());
        Assert.assertEquals((long)0L, (long)((SimpleScore)solverScope.getBestScore()).getScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void improvedUninitializedProcessWorkingSolutionDuringMove() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        InnerScoreDirector sd = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        solverScope.setScoreDirector(sd);
        Solution helpSolution = (Solution)Mockito.mock(Solution.class);
        Mockito.when((Object)helpSolution.getScore()).thenReturn((Object)SimpleScore.parseScore((String)"-2"));
        Mockito.when((Object)sd.cloneWorkingSolution()).thenReturn((Object)helpSolution);
        solverScope.setBestUninitializedVariableCount(1);
        SimpleScore score = SimpleScore.parseScore((String)"-1");
        recaller.processWorkingSolutionDuringMove(0, (Score)score, (AbstractStepScope)stepScope);
        Assert.assertEquals((Object)helpSolution, (Object)solverScope.getBestSolution());
        Assert.assertEquals((long)-2L, (long)((SimpleScore)solverScope.getBestScore()).getScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }

    @Test
    public void improvedInitializedProcessWorkingSolutionDuringMove() {
        BestSolutionRecaller recaller = new BestSolutionRecaller();
        recaller.setSolverEventSupport((SolverEventSupport)Mockito.mock(SolverEventSupport.class));
        DefaultSolverScope solverScope = new DefaultSolverScope();
        ConstructionHeuristicPhaseScope phaseScope = (ConstructionHeuristicPhaseScope)Mockito.mock(ConstructionHeuristicPhaseScope.class);
        Mockito.when((Object)phaseScope.getSolverScope()).thenReturn((Object)solverScope);
        ConstructionHeuristicStepScope stepScope = (ConstructionHeuristicStepScope)Mockito.mock(ConstructionHeuristicStepScope.class);
        Mockito.when((Object)stepScope.getPhaseScope()).thenReturn((Object)phaseScope);
        Solution solution = (Solution)Mockito.mock(Solution.class);
        SimpleScore score = SimpleScore.parseScore((String)"-2");
        Mockito.when((Object)solution.getScore()).thenReturn((Object)score);
        solverScope.setBestScore((Score)score);
        solverScope.setBestSolution(solution);
        InnerScoreDirector sd = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        solverScope.setScoreDirector(sd);
        Solution helpSolution = (Solution)Mockito.mock(Solution.class);
        Mockito.when((Object)helpSolution.getScore()).thenReturn((Object)SimpleScore.parseScore((String)"0"));
        Mockito.when((Object)sd.cloneWorkingSolution()).thenReturn((Object)helpSolution);
        SimpleScore score2 = SimpleScore.parseScore((String)"-1");
        solverScope.setBestUninitializedVariableCount(0);
        recaller.processWorkingSolutionDuringMove(0, (Score)score2, (AbstractStepScope)stepScope);
        Assert.assertEquals((Object)helpSolution, (Object)solverScope.getBestSolution());
        Assert.assertEquals((long)0L, (long)((SimpleScore)solverScope.getBestScore()).getScore());
        Assert.assertEquals((long)0L, (long)solverScope.getBestUninitializedVariableCount());
    }
}

