/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class BendableScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableScoreHolder scoreHolder = new BendableScoreHolder(constraintMatchEnabled, 1, 2);
        scoreHolder.addHardConstraintMatch(this.createRuleContext("scoreRule1"), 0, -1000);
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, 0, -200);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, -30);
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, -3);
        scoreHolder.addSoftConstraintMatch(this.createRuleContext("scoreRule4"), 1, -4);
        Assert.assertEquals((Object)BendableScore.valueOf((int[])new int[]{-1000}, (int[])new int[]{-3, -4}), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)4L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

