/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class BendableLongScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        BendableLongScoreHolder scoreHolder = new BendableLongScoreHolder(constraintMatchEnabled, 1, 2);
        scoreHolder.addHardConstraintMatch(this.createRuleContext("scoreRule1"), 0, 1000000000001L);
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, 0, 1000000000020L);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, 1000000000300L);
        scoreHolder.addSoftConstraintMatch(ruleContext3, 0, 1000000040000L);
        scoreHolder.addSoftConstraintMatch(this.createRuleContext("scoreRule4"), 1, -1000000500000L);
        Assert.assertEquals((Object)BendableLongScore.valueOf((long[])new long[]{1000000000001L}, (long[])new long[]{1000000040000L, -1000000500000L}), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)4L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

