/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScore;
import org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class HardSoftDoubleScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardSoftDoubleScoreHolder scoreHolder = new HardSoftDoubleScoreHolder(constraintMatchEnabled);
        scoreHolder.addHardConstraintMatch(this.createRuleContext("scoreRule1"), -10.0);
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, -2.0);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addSoftConstraintMatch(ruleContext3, -0.3);
        scoreHolder.addSoftConstraintMatch(ruleContext3, -0.06);
        Assert.assertEquals((Object)HardSoftDoubleScore.valueOf((double)-10.0, (double)-0.06), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)3L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

