/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.score.director;

import org.junit.Test;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.impl.score.buildin.bendable.BendableScoreDefinition;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ScoreDirectorFactoryConfigTest {
    @Test
    public void buildSimpleScoreDefinition() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig();
        config.setScoreDefinitionType(ScoreDefinitionType.SIMPLE);
        ScoreDefinition scoreDefinition = config.buildScoreDefinition();
        PlannerAssert.assertInstanceOf(SimpleScoreDefinition.class, scoreDefinition);
    }

    @Test
    public void buildBendableScoreDefinition() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig();
        config.setScoreDefinitionType(ScoreDefinitionType.BENDABLE);
        config.setBendableHardLevelsSize(Integer.valueOf(2));
        config.setBendableSoftLevelsSize(Integer.valueOf(3));
        BendableScoreDefinition scoreDefinition = (BendableScoreDefinition)config.buildScoreDefinition();
        PlannerAssert.assertEquals((long)2L, (long)scoreDefinition.getHardLevelsSize());
        PlannerAssert.assertEquals((long)3L, (long)scoreDefinition.getSoftLevelsSize());
    }
}

