/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.decorator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;

public class ComparatorSelectionSorterTest {
    @Test
    public void sort() {
        Object[] baseArray = new Object[]{3, 4, 3, 5, 1};
        ArrayList<Object> arrayToSort = new ArrayList<Object>();
        Collections.addAll(arrayToSort, baseArray);
        ComparatorSelectionSorter selectionSorter = new ComparatorSelectionSorter((Comparator)new TestComparator(), SelectionSorterOrder.ASCENDING);
        selectionSorter.sort(null, arrayToSort);
        Assert.assertTrue((boolean)this.ascendingSort(arrayToSort));
        arrayToSort = new ArrayList();
        Collections.addAll(arrayToSort, baseArray);
        selectionSorter = new ComparatorSelectionSorter((Comparator)new TestComparator(), SelectionSorterOrder.DESCENDING);
        selectionSorter.sort(null, arrayToSort);
        Assert.assertTrue((boolean)this.descendingSort(arrayToSort));
    }

    private boolean ascendingSort(List<Object> list) {
        Integer tmp = (Integer)list.get(0);
        for (Object aList : list) {
            if (tmp <= (Integer)aList) {
                tmp = (Integer)aList;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean descendingSort(List<Object> list) {
        Integer tmp = (Integer)list.get(0);
        for (Object aList : list) {
            if (tmp >= (Integer)aList) {
                tmp = (Integer)aList;
                continue;
            }
            return false;
        }
        return true;
    }

    private class TestComparator
    implements Comparator<Object> {
        private TestComparator() {
        }

        @Override
        public int compare(Object o, Object o2) {
            Integer first = (Integer)o;
            Integer second = (Integer)o2;
            if (first.intValue() == second.intValue()) {
                return 0;
            }
            return first > second ? 1 : -1;
        }
    }
}

