/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.ParabolicDistributionNearbyRandom;

public class ParabolicDistributionNearbyRandomTest {
    @Test(expected=IllegalArgumentException.class)
    public void sizeMaximumTooLow() {
        ParabolicDistributionNearbyRandom nearbyRandom = new ParabolicDistributionNearbyRandom(-10);
    }

    @Test
    public void nextInt() {
        Random random = (Random)Mockito.mock(Random.class);
        ParabolicDistributionNearbyRandom nearbyRandom = new ParabolicDistributionNearbyRandom(100);
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.0);
        Assert.assertEquals((long)0L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)(1.0 - Math.pow(0.99, 3.0)));
        Assert.assertEquals((long)1L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)(1.0 - Math.pow(0.98, 3.0)));
        Assert.assertEquals((long)2L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)Math.nextAfter(1.0, Double.NEGATIVE_INFINITY));
        Assert.assertEquals((long)99L, (long)nearbyRandom.nextInt(random, 500));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)0.0);
        Assert.assertEquals((long)0L, (long)nearbyRandom.nextInt(random, 10));
        Mockito.when((Object)random.nextDouble()).thenReturn((Object)Math.nextAfter(1.0, Double.NEGATIVE_INFINITY));
        Assert.assertEquals((long)9L, (long)nearbyRandom.nextInt(random, 10));
    }
}

