/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class FromSolutionEntitySelectorTest {
    @Test
    public void originalWithoutEntityListDirtyAndMinimumCacheTypePhase() {
        this.runOriginalWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.PHASE);
    }

    @Test
    public void originalWithoutEntityListDirtyAndMinimumCacheTypeStep() {
        this.runOriginalWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.STEP);
    }

    @Test
    public void originalWithoutEntityListDirtyAndMinimumCacheTypeJustInTime() {
        this.runOriginalWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.JUST_IN_TIME);
    }

    public void runOriginalWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType cacheType) {
        TestdataSolution workingSolution = new TestdataSolution();
        List<Object> entityList = Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(entityList);
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)workingSolution);
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)7L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)false);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, cacheType, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        entitySelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB3.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((EntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)2))).extractEntities((Solution)workingSolution);
    }

    @Test
    public void originalWithEntityListDirty() {
        TestdataSolution workingSolution = new TestdataSolution();
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)workingSolution);
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)7L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)false);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, SelectionCacheType.JUST_IN_TIME, false);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        entitySelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeA1);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("f1"), new TestdataEntity("f2"), new TestdataEntity("f3")));
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)8L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)true);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(8L)).thenReturn((Object)false);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "f1", "f2", "f3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB1);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "f1", "f2", "f3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB2);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "f1", "f2", "f3");
        entitySelector.stepEnded(stepScopeB2);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)9L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(8L)).thenReturn((Object)true);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(9L)).thenReturn((Object)false);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB3.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB3);
        PlannerAssert.assertAllCodesOfEntitySelector((EntitySelector)entitySelector, "e1", "e2", "e3");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((EntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)4))).extractEntities((Solution)workingSolution);
    }

    @Test
    public void randomWithoutEntityListDirtyAndMinimumCacheTypePhase() {
        this.runRandomWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.PHASE);
    }

    @Test
    public void randomWithoutEntityListDirtyAndMinimumCacheTypeStep() {
        this.runRandomWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.STEP);
    }

    @Test
    public void randomWithoutEntityListDirtyAndMinimumCacheTypeJustInTime() {
        this.runRandomWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType.JUST_IN_TIME);
    }

    public void runRandomWithoutEntityListDirtyAndMinimumCacheType(SelectionCacheType cacheType) {
        TestdataSolution workingSolution = new TestdataSolution();
        List<Object> entityList = Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3"));
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(entityList);
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)workingSolution);
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)7L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)false);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, cacheType, true);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1, (Object[])new Integer[]{0, 0, 2, 1, 2, 2, 1, 0});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e2", "e1", "e1", "e3");
        entitySelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA2);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e2", "e3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB1);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB2);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e2");
        entitySelector.stepEnded(stepScopeB2);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB3.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB3);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e1");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((EntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)2))).extractEntities((Solution)workingSolution);
    }

    @Test
    public void randomWithEntityListDirty() {
        TestdataSolution workingSolution = new TestdataSolution();
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        InnerScoreDirector scoreDirector = (InnerScoreDirector)Mockito.mock(InnerScoreDirector.class);
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)workingSolution);
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)7L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)false);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, SelectionCacheType.JUST_IN_TIME, true);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(3)).thenReturn((Object)1, (Object[])new Integer[]{0, 0, 2, 1, 2, 2, 1, 0});
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        entitySelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeA.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA1);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e2", "e1", "e1", "e3");
        entitySelector.stepEnded(stepScopeA1);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("f1"), new TestdataEntity("f2"), new TestdataEntity("f3")));
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)8L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(7L)).thenReturn((Object)true);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(8L)).thenReturn((Object)false);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        Mockito.when((Object)stepScopeA2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeA2);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "f2", "f3");
        entitySelector.stepEnded(stepScopeA2);
        entitySelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        Mockito.when((Object)phaseScopeB.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB1.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB1);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "f3");
        entitySelector.stepEnded(stepScopeB1);
        AbstractStepScope stepScopeB2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB2.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB2.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB2);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "f2");
        entitySelector.stepEnded(stepScopeB2);
        Mockito.when((Object)entityDescriptor.extractEntities((Solution)workingSolution)).thenReturn(Arrays.asList(new TestdataEntity("e1"), new TestdataEntity("e2"), new TestdataEntity("e3")));
        Mockito.when((Object)scoreDirector.getWorkingEntityListRevision()).thenReturn((Object)9L);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(8L)).thenReturn((Object)true);
        Mockito.when((Object)scoreDirector.isWorkingEntityListDirty(9L)).thenReturn((Object)false);
        AbstractStepScope stepScopeB3 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB3.getPhaseScope()).thenReturn((Object)phaseScopeB);
        Mockito.when((Object)stepScopeB3.getScoreDirector()).thenReturn((Object)scoreDirector);
        entitySelector.stepStarted(stepScopeB3);
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector((EntitySelector)entitySelector, 3L, "e1");
        entitySelector.stepEnded(stepScopeB3);
        entitySelector.phaseEnded(phaseScopeB);
        entitySelector.solvingEnded(solverScope);
        ((EntityDescriptor)Mockito.verify((Object)entityDescriptor, (VerificationMode)Mockito.times((int)4))).extractEntities((Solution)workingSolution);
    }

    @Test(expected=IllegalStateException.class)
    public void listIteratorWithRandomSelection() {
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getEntityClass()).thenReturn(TestdataEntity.class);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, SelectionCacheType.JUST_IN_TIME, true);
        entitySelector.listIterator();
    }

    @Test(expected=IllegalStateException.class)
    public void indexedListIteratorWithRandomSelection() {
        EntityDescriptor entityDescriptor = (EntityDescriptor)Mockito.mock(EntityDescriptor.class);
        Mockito.when((Object)entityDescriptor.getEntityClass()).thenReturn(TestdataEntity.class);
        FromSolutionEntitySelector entitySelector = new FromSolutionEntitySelector(entityDescriptor, SelectionCacheType.JUST_IN_TIME, true);
        entitySelector.listIterator(0);
    }
}

