/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.DefaultPillarSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class DefaultPillarSelectorTest {
    @Test
    public void originalNoSubs() {
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataValue val4 = new TestdataValue("4");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val2);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val2);
        TestdataEntity e = new TestdataEntity("e", val3);
        TestdataEntity f = new TestdataEntity("f", val3);
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), a, b, c, d, e, f);
        DefaultPillarSelector pillarSelector = new DefaultPillarSelector(entitySelector, Arrays.asList(variableDescriptor), false, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        pillarSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, "[a]", "[b, d]", "[c, e, f]");
        pillarSelector.stepEnded(stepScopeA1);
        b.setValue(val3);
        f.setValue(val4);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, "[a]", "[b, c, e]", "[d]", "[f]");
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, "[a]", "[b, c, e]", "[d]", "[f]");
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    @Test
    public void emptyEntitySelectorOriginalNoSubs() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), new Object[0]);
        DefaultPillarSelector pillarSelector = new DefaultPillarSelector(entitySelector, Arrays.asList(variableDescriptor), false, false, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        pillarSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        this.assertAllCodesOfPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    @Test
    public void randomWithSubs() {
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataValue val4 = new TestdataValue("4");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val2);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val2);
        TestdataEntity e = new TestdataEntity("e", val3);
        TestdataEntity f = new TestdataEntity("f", val3);
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), a, b, c, d, e, f);
        DefaultPillarSelector pillarSelector = new DefaultPillarSelector(entitySelector, Arrays.asList(variableDescriptor), true, true, 1, Integer.MAX_VALUE);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        pillarSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)0, (Object[])new Integer[]{0, 0, 2, 1, 0, 0, 1, 0, 0, 1, 0, 1});
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, "[a]", "[c, e]", "[b]", "[d]");
        pillarSelector.stepEnded(stepScopeA1);
        b.setValue(val3);
        f.setValue(val4);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0, 0, 1, 2, 2, 0, 0, 1, 0, 0, 2, 0, 0});
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, "[f]", "[e, c, b]", "[b]", "[d]");
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0, 0, 1, 2, 2, 0, 0, 1, 0, 0, 2, 0, 0});
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, "[f]", "[e, c, b]", "[b]", "[d]");
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    @Test
    public void randomWithSubs_Size2() {
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataValue val4 = new TestdataValue("4");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val2);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val2);
        TestdataEntity e = new TestdataEntity("e", val3);
        TestdataEntity f = new TestdataEntity("f", val3);
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), a, b, c, d, e, f);
        DefaultPillarSelector pillarSelector = new DefaultPillarSelector(entitySelector, Arrays.asList(variableDescriptor), true, true, 2, 2);
        Random workingRandom = (Random)Mockito.mock(Random.class);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getWorkingRandom()).thenReturn((Object)workingRandom);
        pillarSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)0, (Object[])new Integer[]{0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0});
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, "[a]", "[c, e]", "[b, d]", "[d, b]");
        pillarSelector.stepEnded(stepScopeA1);
        pillarSelector.phaseEnded(phaseScopeA);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 1, 1);
    }

    @Test
    public void emptyEntitySelectorRandomWithSubs() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        EntitySelector entitySelector = SelectorTestUtils.mockEntitySelector(variableDescriptor.getEntityDescriptor(), new Object[0]);
        DefaultPillarSelector pillarSelector = new DefaultPillarSelector(entitySelector, Arrays.asList(variableDescriptor), true, true, 1, Integer.MAX_VALUE);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        pillarSelector.solvingStarted(solverScope);
        AbstractPhaseScope phaseScopeA = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeA.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeA);
        AbstractStepScope stepScopeA1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA1.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA1);
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeA1);
        AbstractStepScope stepScopeA2 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeA2.getPhaseScope()).thenReturn((Object)phaseScopeA);
        pillarSelector.stepStarted(stepScopeA2);
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeA2);
        pillarSelector.phaseEnded(phaseScopeA);
        AbstractPhaseScope phaseScopeB = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScopeB.getSolverScope()).thenReturn((Object)solverScope);
        pillarSelector.phaseStarted(phaseScopeB);
        AbstractStepScope stepScopeB1 = (AbstractStepScope)Mockito.mock(AbstractStepScope.class);
        Mockito.when((Object)stepScopeB1.getPhaseScope()).thenReturn((Object)phaseScopeB);
        pillarSelector.stepStarted(stepScopeB1);
        this.assertCodesOfNeverEndingPillarSelector((PillarSelector)pillarSelector, new String[0]);
        pillarSelector.stepEnded(stepScopeB1);
        pillarSelector.phaseEnded(phaseScopeB);
        pillarSelector.solvingEnded(solverScope);
        PlannerAssert.verifyPhaseLifecycle((PhaseLifecycleListener)entitySelector, 1, 2, 3);
    }

    private void assertAllCodesOfPillarSelector(PillarSelector pillarSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(pillarSelector.iterator(), codes);
        Assert.assertEquals((Object)true, (Object)pillarSelector.isCountable());
        Assert.assertEquals((Object)false, (Object)pillarSelector.isNeverEnding());
        Assert.assertEquals((long)codes.length, (long)pillarSelector.getSize());
    }

    private void assertCodesOfNeverEndingPillarSelector(PillarSelector pillarSelector, String ... codes) {
        PlannerAssert.assertCodesOfIterator(pillarSelector.iterator(), codes);
        Assert.assertEquals((Object)true, (Object)pillarSelector.isCountable());
        Assert.assertEquals((Object)true, (Object)pillarSelector.isNeverEnding());
    }
}

