/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableDemand;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.SelectorTestUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.TailChainSwapMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class TailChainSwapMoveTest {
    @Test
    public void isMoveDoable() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        Assert.assertEquals((Object)true, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, (Object)b0).isMoveDoable((ScoreDirector)scoreDirector));
        Assert.assertEquals((Object)true, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)b1, (Object)a1).isMoveDoable((ScoreDirector)scoreDirector));
        Assert.assertEquals((Object)true, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a1, (Object)a2).isMoveDoable((ScoreDirector)scoreDirector));
        Assert.assertEquals((Object)true, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a3, (Object)a0).isMoveDoable((ScoreDirector)scoreDirector));
        Assert.assertEquals((Object)false, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a1, (Object)a1).isMoveDoable((ScoreDirector)scoreDirector));
        Assert.assertEquals((Object)false, (Object)new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, (Object)a0).isMoveDoable((ScoreDirector)scoreDirector));
    }

    @Test
    public void doMove() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1);
        TailChainSwapMove move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, (Object)b0);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, b1);
        SelectorTestUtils.assertChain(b0, a2, a3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1);
        move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a2, (Object)b1);
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1);
        SelectorTestUtils.assertChain(b0, b1, a2, a3);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3);
        SelectorTestUtils.assertChain(b0, b1);
    }

    @Test
    public void doMoveInSameChain() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        SolutionDescriptor solutionDescriptor = variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        InnerScoreDirector scoreDirector = PlannerTestUtils.mockScoreDirector(solutionDescriptor);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedEntity a4 = new TestdataChainedEntity("a4", a3);
        TestdataChainedEntity a5 = new TestdataChainedEntity("a5", a4);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, a4, a5));
        scoreDirector.setWorkingSolution((Solution)solution);
        SingletonInverseVariableSupply inverseVariableSupply = (SingletonInverseVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new SingletonInverseVariableDemand((VariableDescriptor)variableDescriptor));
        AnchorVariableSupply anchorVariableSupply = (AnchorVariableSupply)scoreDirector.getSupplyManager().demand((Demand)new AnchorVariableDemand((VariableDescriptor)variableDescriptor));
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        TailChainSwapMove move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a4, (Object)a1);
        Move undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a4, a3, a2, a5);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a3, (Object)a1);
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a3, a2, a4, a5);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a5, (Object)a1);
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a5, a4, a3, a2);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
        move = new TailChainSwapMove(variableDescriptor, inverseVariableSupply, anchorVariableSupply, (Object)a1, (Object)a4);
        undoMove = move.createUndoMove((ScoreDirector)scoreDirector);
        move.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a5, a2, a3, a4, a1);
        undoMove.doMove((ScoreDirector)scoreDirector);
        SelectorTestUtils.assertChain(a0, a1, a2, a3, a4, a5);
    }
}

