/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoftlong;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardMediumSoftLongScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)3L, (long)new HardMediumSoftLongScoreDefinition().getLevelsSize());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new HardMediumSoftLongScoreDefinition().getFeasibleLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        HardMediumSoftLongScoreDefinition scoreDefinition = new HardMediumSoftLongScoreDefinition();
        HardMediumSoftLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)3), HardMediumSoftLongScore.valueOf((long)-1L, (long)-2L, (long)-3L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getMediumScore());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        HardMediumSoftLongScoreDefinition scoreDefinition = new HardMediumSoftLongScoreDefinition();
        HardMediumSoftLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)3), HardMediumSoftLongScore.valueOf((long)-1L, (long)-2L, (long)-3L));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)optimisticBound.getMediumScore());
        Assert.assertEquals((long)-3L, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        HardMediumSoftLongScoreDefinition scoreDefinition = new HardMediumSoftLongScoreDefinition();
        HardMediumSoftLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)3), HardMediumSoftLongScore.valueOf((long)-1L, (long)-2L, (long)-3L));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getMediumScore());
        Assert.assertEquals((long)-3L, (long)pessimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        HardMediumSoftLongScoreDefinition scoreDefinition = new HardMediumSoftLongScoreDefinition();
        HardMediumSoftLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)3), HardMediumSoftLongScore.valueOf((long)-1L, (long)-2L, (long)-3L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getMediumScore());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getSoftScore());
    }
}

