/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.buildin.composite.CompositeCountableValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class CompositeCountableValueRangeTest {
    private <T> CompositeCountableValueRange<T> createValueRange(List<T> ... lists) {
        ArrayList<ListValueRange> childValueRangeList = new ArrayList<ListValueRange>(lists.length);
        for (List<T> list : lists) {
            childValueRangeList.add(new ListValueRange(list));
        }
        return new CompositeCountableValueRange(childValueRangeList);
    }

    @Test
    public void getSize() {
        Assert.assertEquals((long)7L, (long)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).getSize());
        Assert.assertEquals((long)4L, (long)this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).getSize());
        Assert.assertEquals((long)0L, (long)this.createValueRange(Collections.emptyList(), Collections.emptyList()).getSize());
    }

    @Test
    public void get() {
        Assert.assertEquals((long)5L, (long)((Integer)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).get(2L)).intValue());
        Assert.assertEquals((long)-15L, (long)((Integer)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).get(4L)).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).get(6L)).intValue());
        Assert.assertEquals((Object)"c", (Object)this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).get(2L));
    }

    @Test
    public void contains() {
        Assert.assertEquals((Object)true, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)5));
        Assert.assertEquals((Object)false, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)4));
        Assert.assertEquals((Object)true, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)-15));
        Assert.assertEquals((Object)false, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)-14));
        Assert.assertEquals((Object)true, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)-1));
        Assert.assertEquals((Object)false, (Object)this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).contains((Object)1));
        Assert.assertEquals((Object)true, (Object)this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).contains((Object)"c"));
        Assert.assertEquals((Object)false, (Object)this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).contains((Object)"n"));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).createOriginalIterator(), 0, 2, 5, 10, -15, 25, -1);
        PlannerAssert.assertAllElementsOfIterator(this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).createOriginalIterator(), "a", "b", "c", "d");
        PlannerAssert.assertAllElementsOfIterator(this.createValueRange(Collections.emptyList(), Collections.emptyList()).createOriginalIterator(), new String[0]);
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(this.createValueRange(Arrays.asList(0, 2, 5, 10), Arrays.asList(-15, 25, -1)).createRandomIterator(workingRandom), 10, 0);
        Mockito.when((Object)workingRandom.nextInt(Matchers.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(this.createValueRange(Arrays.asList("a", "b"), Arrays.asList("c"), Arrays.asList("d")).createRandomIterator(workingRandom), "d", "a");
        PlannerAssert.assertElementsOfIterator(this.createValueRange(Collections.emptyList(), Collections.emptyList()).createRandomIterator(workingRandom), new String[0]);
    }
}

