/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.primlong;

import java.util.Random;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.valuerange.buildin.primlong.LongValueRange;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class LongValueRangeTest {
    @Test
    public void getSize() {
        PlannerAssert.assertEquals((long)10L, (long)new LongValueRange(0L, 10L).getSize());
        PlannerAssert.assertEquals((long)20L, (long)new LongValueRange(100L, 120L).getSize());
        PlannerAssert.assertEquals((long)40L, (long)new LongValueRange(-15L, 25L).getSize());
        PlannerAssert.assertEquals((long)0L, (long)new LongValueRange(7L, 7L).getSize());
        PlannerAssert.assertEquals((long)9223372036854773807L, (long)new LongValueRange(-1000L, 0x7FFFFFFFFFFFF447L).getSize());
        PlannerAssert.assertEquals((long)5L, (long)new LongValueRange(0L, 10L, 2L).getSize());
        PlannerAssert.assertEquals((long)5L, (long)new LongValueRange(-1L, 9L, 2L).getSize());
        PlannerAssert.assertEquals((long)4L, (long)new LongValueRange(100L, 120L, 5L).getSize());
    }

    @Test
    public void get() {
        PlannerAssert.assertEquals((long)3L, (long)new LongValueRange(0L, 10L).get(3L).intValue());
        PlannerAssert.assertEquals((long)103L, (long)new LongValueRange(100L, 120L).get(3L).intValue());
        PlannerAssert.assertEquals((long)-4L, (long)new LongValueRange(-5L, 25L).get(1L).intValue());
        PlannerAssert.assertEquals((long)1L, (long)new LongValueRange(-5L, 25L).get(6L).intValue());
        PlannerAssert.assertEquals((long)4L, (long)new LongValueRange(-1000L, 0x7FFFFFFFFFFFF447L).get(1004L).intValue());
        PlannerAssert.assertEquals((long)6L, (long)new LongValueRange(0L, 10L, 2L).get(3L).intValue());
        PlannerAssert.assertEquals((long)5L, (long)new LongValueRange(-1L, 9L, 2L).get(3L).intValue());
        PlannerAssert.assertEquals((long)115L, (long)new LongValueRange(100L, 120L, 5L).get(3L).intValue());
    }

    @Test
    public void contains() {
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(0L, 10L).contains(Long.valueOf(3L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(0L, 10L).contains(Long.valueOf(10L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(0L, 10L).contains(null));
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(100L, 120L).contains(Long.valueOf(100L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(100L, 120L).contains(Long.valueOf(99L)));
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(-5L, 25L).contains(Long.valueOf(-4L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(-5L, 25L).contains(Long.valueOf(-20L)));
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(0L, 10L, 2L).contains(Long.valueOf(2L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(0L, 10L, 2L).contains(Long.valueOf(3L)));
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(-1L, 9L, 2L).contains(Long.valueOf(1L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(-1L, 9L, 2L).contains(Long.valueOf(2L)));
        PlannerAssert.assertEquals((Object)true, (Object)new LongValueRange(100L, 120L, 5L).contains(Long.valueOf(115L)));
        PlannerAssert.assertEquals((Object)false, (Object)new LongValueRange(100L, 120L, 5L).contains(Long.valueOf(114L)));
    }

    @Test
    public void createOriginalIterator() {
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(0L, 7L).createOriginalIterator(), 0L, 1L, 2L, 3L, 4L, 5L, 6L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(100L, 104L).createOriginalIterator(), 100L, 101L, 102L, 103L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(-4L, 3L).createOriginalIterator(), -4L, -3L, -2L, -1L, 0L, 1L, 2L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(7L, 7L).createOriginalIterator(), new Long[0]);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(0L, 10L, 2L).createOriginalIterator(), 0L, 2L, 4L, 6L, 8L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(-1L, 9L, 2L).createOriginalIterator(), -1L, 1L, 3L, 5L, 7L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(100L, 120L, 5L).createOriginalIterator(), 100L, 105L, 110L, 115L);
    }

    @Test
    public void createRandomIterator() {
        Random workingRandom = (Random)Mockito.mock(Random.class);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(0L, 7L).createRandomIterator(workingRandom), 3L, 0L);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(100L, 104L).createRandomIterator(workingRandom), 103L, 100L);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(-4L, 3L).createRandomIterator(workingRandom), -1L, -4L);
        PlannerAssert.assertAllElementsOfIterator(new LongValueRange(7L, 7L).createRandomIterator(workingRandom), new Long[0]);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(0L, 10L, 2L).createRandomIterator(workingRandom), 6L, 0L);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(-1L, 9L, 2L).createRandomIterator(workingRandom), 5L, -1L);
        Mockito.when((Object)workingRandom.nextInt(Mockito.anyInt())).thenReturn((Object)3, (Object[])new Integer[]{0});
        PlannerAssert.assertElementsOfIterator(new LongValueRange(100L, 120L, 5L).createRandomIterator(workingRandom), 115L, 100L);
    }
}

