/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.anchor;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.anchor.ExternalizedAnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.ExternalizedSingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.TestdataChainedSolution;

public class ExternalizedAnchorVariableSupplyTest {
    @Test
    public void chainedEntity() {
        GenuineVariableDescriptor variableDescriptor = TestdataChainedEntity.buildVariableDescriptorForChainedObject();
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        ExternalizedSingletonInverseVariableSupply nextVariableSupply = new ExternalizedSingletonInverseVariableSupply((VariableDescriptor)variableDescriptor);
        ExternalizedAnchorVariableSupply supply = new ExternalizedAnchorVariableSupply((VariableDescriptor)variableDescriptor, (SingletonInverseVariableSupply)nextVariableSupply);
        TestdataChainedAnchor a0 = new TestdataChainedAnchor("a0");
        TestdataChainedEntity a1 = new TestdataChainedEntity("a1", a0);
        TestdataChainedEntity a2 = new TestdataChainedEntity("a2", a1);
        TestdataChainedEntity a3 = new TestdataChainedEntity("a3", a2);
        TestdataChainedAnchor b0 = new TestdataChainedAnchor("b0");
        TestdataChainedEntity b1 = new TestdataChainedEntity("b1", b0);
        TestdataChainedSolution solution = new TestdataChainedSolution("solution");
        solution.setChainedAnchorList(Arrays.asList(a0, b0));
        solution.setChainedEntityList(Arrays.asList(a1, a2, a3, b1));
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        nextVariableSupply.resetWorkingSolution(scoreDirector);
        supply.resetWorkingSolution(scoreDirector);
        Assert.assertSame((Object)a0, (Object)supply.getAnchor((Object)a1));
        Assert.assertSame((Object)a0, (Object)supply.getAnchor((Object)a2));
        Assert.assertSame((Object)a0, (Object)supply.getAnchor((Object)a3));
        Assert.assertSame((Object)b0, (Object)supply.getAnchor((Object)b1));
        nextVariableSupply.beforeVariableChanged(scoreDirector, (Object)a3);
        supply.beforeVariableChanged(scoreDirector, (Object)a3);
        a3.setChainedObject(b1);
        nextVariableSupply.afterVariableChanged(scoreDirector, (Object)a3);
        supply.afterVariableChanged(scoreDirector, (Object)a3);
        Assert.assertSame((Object)a0, (Object)supply.getAnchor((Object)a1));
        Assert.assertSame((Object)a0, (Object)supply.getAnchor((Object)a2));
        Assert.assertSame((Object)b0, (Object)supply.getAnchor((Object)a3));
        Assert.assertSame((Object)b0, (Object)supply.getAnchor((Object)b1));
        nextVariableSupply.clearWorkingSolution(scoreDirector);
        supply.clearWorkingSolution(scoreDirector);
    }
}

