/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.inverserelation;

import java.util.Arrays;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.ExternalizedCollectionInverseVariableSupply;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;

public class ExternalizedCollectionInverseVariableSupplyTest {
    @Test
    public void normal() {
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        ExternalizedCollectionInverseVariableSupply supply = new ExternalizedCollectionInverseVariableSupply((VariableDescriptor)variableDescriptor);
        TestdataValue val1 = new TestdataValue("1");
        TestdataValue val2 = new TestdataValue("2");
        TestdataValue val3 = new TestdataValue("3");
        TestdataEntity a = new TestdataEntity("a", val1);
        TestdataEntity b = new TestdataEntity("b", val1);
        TestdataEntity c = new TestdataEntity("c", val3);
        TestdataEntity d = new TestdataEntity("d", val3);
        TestdataSolution solution = new TestdataSolution("solution");
        solution.setEntityList(Arrays.asList(a, b, c, d));
        solution.setValueList(Arrays.asList(val1, val2, val3));
        Mockito.when((Object)scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        supply.resetWorkingSolution(scoreDirector);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val1), a, b);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val2), new Object[0]);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val3), c, d);
        supply.beforeVariableChanged(scoreDirector, (Object)c);
        c.setValue(val2);
        supply.afterVariableChanged(scoreDirector, (Object)c);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val1), a, b);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val2), c);
        PlannerAssert.assertCollectionContainsExactly(supply.getInverseCollection((Object)val3), d);
        supply.clearWorkingSolution(scoreDirector);
    }
}

