/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.entityproviding.TestdataEntityProvidingEntity;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataMultiVarEntity;
import org.optaplanner.core.impl.testdata.domain.multivar.TestdataOtherValue;

public class ChangeMoveTest {
    @Test
    public void isMoveDoable() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        ChangeMove aMove = new ChangeMove((Object)a, entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v2);
        a.setValue(v1);
        Assert.assertEquals((Object)true, (Object)aMove.isMoveDoable(scoreDirector));
        a.setValue(v2);
        Assert.assertEquals((Object)false, (Object)aMove.isMoveDoable(scoreDirector));
        a.setValue(v3);
        Assert.assertEquals((Object)true, (Object)aMove.isMoveDoable(scoreDirector));
    }

    @Test
    public void doMove() {
        TestdataValue v1 = new TestdataValue("1");
        TestdataValue v2 = new TestdataValue("2");
        TestdataValue v3 = new TestdataValue("3");
        TestdataEntityProvidingEntity a = new TestdataEntityProvidingEntity("a", Arrays.asList(v1, v2, v3), null);
        ScoreDirector scoreDirector = (ScoreDirector)Mockito.mock(ScoreDirector.class);
        EntityDescriptor entityDescriptor = TestdataEntityProvidingEntity.buildEntityDescriptor();
        ChangeMove aMove = new ChangeMove((Object)a, entityDescriptor.getGenuineVariableDescriptor("value"), (Object)v2);
        a.setValue(v1);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        a.setValue(v2);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
        a.setValue(v3);
        aMove.doMove(scoreDirector);
        Assert.assertEquals((Object)v2, (Object)a.getValue());
    }

    @Test
    public void toStringTest() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataEntity a = new TestdataEntity("a", null);
        TestdataEntity b = new TestdataEntity("b", v1);
        GenuineVariableDescriptor variableDescriptor = TestdataEntity.buildVariableDescriptorForValue();
        Assert.assertEquals((Object)"a {null -> null}", (Object)new ChangeMove((Object)a, variableDescriptor, null).toString());
        Assert.assertEquals((Object)"a {null -> v1}", (Object)new ChangeMove((Object)a, variableDescriptor, (Object)v1).toString());
        Assert.assertEquals((Object)"a {null -> v2}", (Object)new ChangeMove((Object)a, variableDescriptor, (Object)v2).toString());
        Assert.assertEquals((Object)"b {v1 -> null}", (Object)new ChangeMove((Object)b, variableDescriptor, null).toString());
        Assert.assertEquals((Object)"b {v1 -> v1}", (Object)new ChangeMove((Object)b, variableDescriptor, (Object)v1).toString());
        Assert.assertEquals((Object)"b {v1 -> v2}", (Object)new ChangeMove((Object)b, variableDescriptor, (Object)v2).toString());
    }

    @Test
    public void toStringTestMultiVar() {
        TestdataValue v1 = new TestdataValue("v1");
        TestdataValue v2 = new TestdataValue("v2");
        TestdataValue v3 = new TestdataValue("v3");
        TestdataValue v4 = new TestdataValue("v4");
        TestdataOtherValue w1 = new TestdataOtherValue("w1");
        TestdataOtherValue w2 = new TestdataOtherValue("w2");
        TestdataMultiVarEntity a = new TestdataMultiVarEntity("a", null, null, null);
        TestdataMultiVarEntity b = new TestdataMultiVarEntity("b", v1, v3, w1);
        TestdataMultiVarEntity c = new TestdataMultiVarEntity("c", v2, v4, w2);
        EntityDescriptor entityDescriptor = TestdataMultiVarEntity.buildEntityDescriptor();
        GenuineVariableDescriptor variableDescriptor = entityDescriptor.getGenuineVariableDescriptor("secondaryValue");
        Assert.assertEquals((Object)"a {null -> null}", (Object)new ChangeMove((Object)a, variableDescriptor, null).toString());
        Assert.assertEquals((Object)"a {null -> v1}", (Object)new ChangeMove((Object)a, variableDescriptor, (Object)v1).toString());
        Assert.assertEquals((Object)"a {null -> v2}", (Object)new ChangeMove((Object)a, variableDescriptor, (Object)v2).toString());
        Assert.assertEquals((Object)"b {v3 -> null}", (Object)new ChangeMove((Object)b, variableDescriptor, null).toString());
        Assert.assertEquals((Object)"b {v3 -> v1}", (Object)new ChangeMove((Object)b, variableDescriptor, (Object)v1).toString());
        Assert.assertEquals((Object)"b {v3 -> v2}", (Object)new ChangeMove((Object)b, variableDescriptor, (Object)v2).toString());
        Assert.assertEquals((Object)"c {v4 -> v3}", (Object)new ChangeMove((Object)c, variableDescriptor, (Object)v3).toString());
    }
}

