/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.testdata.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.impl.constructionheuristic.event.ConstructionHeuristicPhaseLifecycleListener;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import org.optaplanner.core.impl.heuristic.move.CompositeMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMove;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;
import org.optaplanner.core.impl.localsearch.event.LocalSearchPhaseLifecycleListener;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.testdata.util.CodeAssertable;

public class PlannerAssert
extends Assert {
    public static final long DO_NOT_ASSERT_SIZE = Long.MIN_VALUE;

    public static void assertInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (!expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static void assertNotInstanceOf(Class expectedClass, Object actualInstance) {
        PlannerAssert.assertNotInstanceOf(null, expectedClass, actualInstance);
    }

    public static void assertNotInstanceOf(String message, Class expectedClass, Object actualInstance) {
        if (expectedClass.isInstance(actualInstance)) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, "not " + expectedClass.getName(), actualInstance == null ? "null" : actualInstance.getClass().getName());
        }
    }

    public static <E> void assertCollectionContainsExactly(Collection<E> collection, E ... elements) {
        PlannerAssert.assertEquals((long)elements.length, (long)collection.size());
        PlannerAssert.assertCollectionContains(collection, elements);
    }

    public static <E> void assertCollectionContains(Collection<E> collection, E ... elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (collection.contains(elements[i])) continue;
            PlannerAssert.fail((String)("The asserted collection (" + collection + ") does not contain expected element (" + elements[i] + ")"));
        }
    }

    public static void verifyPhaseLifecycle(PhaseLifecycleListener phaseLifecycleListener, int solvingCount, int phaseCount, int stepCount) {
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingStarted((DefaultSolverScope)Matchers.any());
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseStarted((AbstractPhaseScope)Matchers.any());
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepStarted((AbstractStepScope)Matchers.any());
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepEnded((AbstractStepScope)Matchers.any());
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseEnded((AbstractPhaseScope)Matchers.any());
        ((PhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingEnded((DefaultSolverScope)Matchers.any());
    }

    public static void verifyPhaseLifecycle(ConstructionHeuristicPhaseLifecycleListener phaseLifecycleListener, int solvingCount, int phaseCount, int stepCount) {
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingStarted((DefaultSolverScope)Matchers.any());
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseStarted((ConstructionHeuristicPhaseScope)Matchers.any());
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepStarted((ConstructionHeuristicStepScope)Matchers.any());
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepEnded((ConstructionHeuristicStepScope)Matchers.any());
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseEnded((ConstructionHeuristicPhaseScope)Matchers.any());
        ((ConstructionHeuristicPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingEnded((DefaultSolverScope)Matchers.any());
    }

    public static void verifyPhaseLifecycle(LocalSearchPhaseLifecycleListener phaseLifecycleListener, int solvingCount, int phaseCount, int stepCount) {
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingStarted((DefaultSolverScope)Matchers.any());
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseStarted((LocalSearchPhaseScope)Matchers.any());
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepStarted((LocalSearchStepScope)Matchers.any());
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)stepCount))).stepEnded((LocalSearchStepScope)Matchers.any());
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)phaseCount))).phaseEnded((LocalSearchPhaseScope)Matchers.any());
        ((LocalSearchPhaseLifecycleListener)Mockito.verify((Object)phaseLifecycleListener, (VerificationMode)Mockito.times((int)solvingCount))).solvingEnded((DefaultSolverScope)Matchers.any());
    }

    public static <O> void assertElementsOfIterator(Iterator<O> iterator, O ... elements) {
        PlannerAssert.assertNotNull(iterator);
        for (O element : elements) {
            PlannerAssert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertEquals(element, iterator.next());
        }
    }

    public static <O> void assertAllElementsOfIterator(Iterator<O> iterator, O ... elements) {
        PlannerAssert.assertElementsOfIterator(iterator, elements);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
    }

    private static CodeAssertable convertToCodeAssertable(Object o) {
        PlannerAssert.assertNotNull((Object)o);
        if (o instanceof CodeAssertable) {
            return (CodeAssertable)o;
        }
        if (o instanceof ChangeMove) {
            ChangeMove changeMove = (ChangeMove)o;
            final String code = PlannerAssert.convertToCodeAssertable(changeMove.getEntity()).getCode() + "->" + PlannerAssert.convertToCodeAssertable(changeMove.getToPlanningValue()).getCode();
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        if (o instanceof SwapMove) {
            SwapMove swapMove = (SwapMove)o;
            final String code = PlannerAssert.convertToCodeAssertable(swapMove.getLeftEntity()).getCode() + "<->" + PlannerAssert.convertToCodeAssertable(swapMove.getRightEntity()).getCode();
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        if (o instanceof CompositeMove) {
            CompositeMove compositeMove = (CompositeMove)o;
            StringBuilder codeBuilder = new StringBuilder(compositeMove.getMoves().length * 80);
            for (Move move : compositeMove.getMoves()) {
                codeBuilder.append("+").append(PlannerAssert.convertToCodeAssertable(move).getCode());
            }
            final String code = codeBuilder.substring(1);
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        if (o instanceof List) {
            List list = (List)o;
            StringBuilder codeBuilder = new StringBuilder("[");
            boolean firstElement = true;
            for (Object element : list) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    codeBuilder.append(", ");
                }
                codeBuilder.append(PlannerAssert.convertToCodeAssertable(element).getCode());
            }
            codeBuilder.append("]");
            final String code = codeBuilder.toString();
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        if (o instanceof SubChain) {
            SubChain subChain = (SubChain)o;
            final String code = PlannerAssert.convertToCodeAssertable(subChain.getEntityList()).getCode();
            return new CodeAssertable(){

                @Override
                public String getCode() {
                    return code;
                }
            };
        }
        throw new AssertionError((Object)("o's class (" + o.getClass() + ") cannot be converted to CodeAssertable."));
    }

    public static void assertCode(String expectedCode, Object o) {
        if (expectedCode == null) {
            PlannerAssert.assertNull((Object)o);
        } else {
            CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
            PlannerAssert.assertCode(expectedCode, codeAssertable);
        }
    }

    public static void assertCode(String message, String expectedCode, Object o) {
        CodeAssertable codeAssertable = PlannerAssert.convertToCodeAssertable(o);
        PlannerAssert.assertCode(message, expectedCode, codeAssertable);
    }

    public static void assertCode(String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static void assertCode(String message, String expectedCode, CodeAssertable codeAssertable) {
        PlannerAssert.assertEquals((String)message, (Object)expectedCode, (Object)codeAssertable.getCode());
    }

    public static <O> void assertAllCodesOfArray(O[] array, String ... codes) {
        PlannerAssert.assertNotNull(array);
        PlannerAssert.assertEquals((long)codes.length, (long)array.length);
        for (int i = 0; i < array.length; ++i) {
            PlannerAssert.assertCode(codes[i], array[i]);
        }
    }

    public static <O> void assertCodesOfIterator(Iterator<O> iterator, String ... codes) {
        PlannerAssert.assertNotNull(iterator);
        for (String code : codes) {
            PlannerAssert.assertTrue((boolean)iterator.hasNext());
            PlannerAssert.assertCode(code, iterator.next());
        }
    }

    public static <O> void assertAllCodesOfIterator(Iterator<O> iterator, String ... codes) {
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
    }

    public static void assertAllCodesOfMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfMoveSelector(moveSelector, codes.length, codes);
    }

    public static void assertAllCodesOfMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(moveSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, String ... codes) {
        PlannerAssert.assertCodesOfNeverEndingMoveSelector(moveSelector, Long.MIN_VALUE, codes);
    }

    public static void assertCodesOfNeverEndingMoveSelector(MoveSelector moveSelector, long size, String ... codes) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isCountable());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertEmptyNeverEndingMoveSelector(MoveSelector moveSelector) {
        PlannerAssert.assertEmptyNeverEndingMoveSelector(moveSelector, 0L);
    }

    public static void assertEmptyNeverEndingMoveSelector(MoveSelector moveSelector, long size) {
        Iterator iterator = moveSelector.iterator();
        PlannerAssert.assertFalse((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isCountable());
        PlannerAssert.assertEquals((Object)true, (Object)moveSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)moveSelector.getSize());
        }
    }

    public static void assertAllCodesOfEntitySelector(EntitySelector entitySelector, String ... codes) {
        PlannerAssert.assertAllCodesOfEntitySelector(entitySelector, codes.length, codes);
    }

    public static void assertAllCodesOfEntitySelector(EntitySelector entitySelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(entitySelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)true, (Object)entitySelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)entitySelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)entitySelector.getSize());
        }
    }

    public static void assertCodesOfNeverEndingOfEntitySelector(EntitySelector entitySelector, String ... codes) {
        PlannerAssert.assertCodesOfNeverEndingOfEntitySelector(entitySelector, Long.MIN_VALUE, codes);
    }

    public static void assertCodesOfNeverEndingOfEntitySelector(EntitySelector entitySelector, long size, String ... codes) {
        Iterator iterator = entitySelector.iterator();
        PlannerAssert.assertCodesOfIterator(iterator, codes);
        PlannerAssert.assertTrue((boolean)iterator.hasNext());
        PlannerAssert.assertEquals((Object)true, (Object)entitySelector.isCountable());
        PlannerAssert.assertEquals((Object)true, (Object)entitySelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)entitySelector.getSize());
        }
    }

    public static void assertAllCodesOfPillarSelector(PillarSelector pillarSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfPillarSelector(pillarSelector, codes.length, codes);
    }

    public static void assertAllCodesOfPillarSelector(PillarSelector pillarSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(pillarSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)true, (Object)pillarSelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)pillarSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)pillarSelector.getSize());
        }
    }

    public static void assertAllCodesOfValueSelector(EntityIndependentValueSelector valueSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfValueSelector(valueSelector, codes.length, codes);
    }

    public static void assertAllCodesOfValueSelector(EntityIndependentValueSelector valueSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(valueSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)true, (Object)valueSelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)valueSelector.getSize());
        }
    }

    public static void assertAllCodesOfValueSelectorForEntity(ValueSelector valueSelector, Object entity, String ... codes) {
        PlannerAssert.assertAllCodesOfValueSelectorForEntity(valueSelector, entity, codes.length, codes);
    }

    public static void assertAllCodesOfValueSelectorForEntity(ValueSelector valueSelector, Object entity, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(valueSelector.iterator(entity), codes);
        PlannerAssert.assertEquals((Object)true, (Object)valueSelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)valueSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)valueSelector.getSize(entity));
        }
    }

    public static void assertAllCodesOfSubChainSelector(SubChainSelector subChainSelector, String ... codes) {
        PlannerAssert.assertAllCodesOfSubChainSelector(subChainSelector, codes.length, codes);
    }

    public static void assertAllCodesOfSubChainSelector(SubChainSelector subChainSelector, long size, String ... codes) {
        PlannerAssert.assertAllCodesOfIterator(subChainSelector.iterator(), codes);
        PlannerAssert.assertEquals((Object)true, (Object)subChainSelector.isCountable());
        PlannerAssert.assertEquals((Object)false, (Object)subChainSelector.isNeverEnding());
        if (size != Long.MIN_VALUE) {
            PlannerAssert.assertEquals((long)size, (long)subChainSelector.getSize());
        }
    }

    private PlannerAssert() {
    }
}

