/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.policy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;

public class DescriptorPolicy {
    private Map<String, Method> fromSolutionValueRangeProviderMap = new LinkedHashMap<String, Method>();
    private Map<String, Method> fromEntityValueRangeProviderMap = new LinkedHashMap<String, Method>();

    public void addFromSolutionValueRangeProvider(Method method) {
        String id = this.extractValueRangeProviderId(method);
        this.fromSolutionValueRangeProviderMap.put(id, method);
    }

    public boolean hasFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.containsKey(id);
    }

    public Method getFromSolutionValueRangeProvider(String id) {
        return this.fromSolutionValueRangeProviderMap.get(id);
    }

    public void addFromEntityValueRangeProvider(Method method) {
        String id = this.extractValueRangeProviderId(method);
        this.fromEntityValueRangeProviderMap.put(id, method);
    }

    public boolean hasFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.containsKey(id);
    }

    public Method getFromEntityValueRangeProvider(String id) {
        return this.fromEntityValueRangeProviderMap.get(id);
    }

    private String extractValueRangeProviderId(Method method) {
        ValueRangeProvider annotation = method.getAnnotation(ValueRangeProvider.class);
        String id = annotation.id();
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalStateException("The " + ValueRangeProvider.class.getSimpleName() + " annotated method (" + method + ")'s id (" + id + ") must not be empty.");
        }
        this.validateUniqueValueRangeProviderId(id, method);
        return id;
    }

    private void validateUniqueValueRangeProviderId(String id, Method method) {
        Method duplicate = this.fromSolutionValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 methods (" + duplicate + ", " + method + ") with a " + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
        duplicate = this.fromEntityValueRangeProviderMap.get(id);
        if (duplicate != null) {
            throw new IllegalStateException("2 methods (" + duplicate + ", " + method + ") with a " + ValueRangeProvider.class.getSimpleName() + " annotation must not have the same id (" + id + ").");
        }
    }

    public Collection<String> getValueRangeProviderIds() {
        ArrayList<String> valueRangeProviderIds = new ArrayList<String>(this.fromSolutionValueRangeProviderMap.size() + this.fromEntityValueRangeProviderMap.size());
        valueRangeProviderIds.addAll(this.fromSolutionValueRangeProviderMap.keySet());
        valueRangeProviderIds.addAll(this.fromEntityValueRangeProviderMap.keySet());
        return valueRangeProviderIds;
    }
}

