/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;

public abstract class VariableDescriptor {
    protected final EntityDescriptor entityDescriptor;
    protected final PropertyAccessor variablePropertyAccessor;
    protected final String variableName;
    private List<ShadowVariableDescriptor> shadowVariableDescriptorList = new ArrayList<ShadowVariableDescriptor>(4);

    public VariableDescriptor(EntityDescriptor entityDescriptor, PropertyAccessor variablePropertyAccessor) {
        this.entityDescriptor = entityDescriptor;
        this.variablePropertyAccessor = variablePropertyAccessor;
        this.variableName = variablePropertyAccessor.getName();
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getSimpleEntityAndVariableName() {
        return this.entityDescriptor.getEntityClass().getSimpleName() + "." + this.variableName;
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyAccessor.getPropertyType();
    }

    public void registerShadowVariableDescriptor(ShadowVariableDescriptor shadowVariableDescriptor) {
        this.shadowVariableDescriptorList.add(shadowVariableDescriptor);
    }

    public List<ShadowVariableDescriptor> getShadowVariableDescriptorList() {
        return this.shadowVariableDescriptorList;
    }

    public boolean isValueNoPotentialAnchor(Object value) {
        return this.entityDescriptor.getEntityClass().isAssignableFrom(value.getClass());
    }

    public Object getValue(Object entity) {
        return this.variablePropertyAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variablePropertyAccessor.executeSetter(entity, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + " of " + this.entityDescriptor.getEntityClass().getName() + ")";
    }
}

