/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.impl.score.buildin.bendablebigdecimal.BendableBigDecimalScoreDefinition;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class BendableBigDecimalScoreTest
extends AbstractScoreTest {
    private static final BigDecimal PLUS_4000 = BigDecimal.valueOf(4000L);
    private static final BigDecimal PLUS_300 = BigDecimal.valueOf(300L);
    private static final BigDecimal PLUS_280 = BigDecimal.valueOf(280L);
    private static final BigDecimal PLUS_25 = BigDecimal.valueOf(25L);
    private static final BigDecimal PLUS_24 = BigDecimal.valueOf(24L);
    private static final BigDecimal PLUS_21 = BigDecimal.valueOf(21L);
    private static final BigDecimal PLUS_20 = BigDecimal.valueOf(20L);
    private static final BigDecimal PLUS_19 = BigDecimal.valueOf(19L);
    private static final BigDecimal PLUS_16 = BigDecimal.valueOf(16L);
    private static final BigDecimal NINE = BigDecimal.valueOf(9L);
    private static final BigDecimal FIVE = BigDecimal.valueOf(5L);
    private static final BigDecimal FOUR = BigDecimal.valueOf(4L);
    private static final BigDecimal THREE = BigDecimal.valueOf(3L);
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal MINUS_ONE = ONE.negate();
    private static final BigDecimal MINUS_THREE = THREE.negate();
    private static final BigDecimal MINUS_FOUR = FOUR.negate();
    private static final BigDecimal MINUS_FIVE = FIVE.negate();
    private static final BigDecimal MINUS_TEN = BigDecimal.TEN.negate();
    private static final BigDecimal MINUS_20 = PLUS_20.negate();
    private static final BigDecimal MINUS_21 = PLUS_21.negate();
    private static final BigDecimal MINUS_24 = PLUS_24.negate();
    private static final BigDecimal MINUS_25 = PLUS_25.negate();
    private static final BigDecimal MINUS_30 = BigDecimal.valueOf(-30L);
    private static final BigDecimal MINUS_300 = PLUS_300.negate();
    private static final BigDecimal MINUS_320 = BigDecimal.valueOf(-320L);
    private static final BigDecimal MINUS_4000 = PLUS_4000.negate();
    private static final BigDecimal MINUS_5000 = BigDecimal.valueOf(-5000L);
    private static final BigDecimal MINUS_8000 = BigDecimal.valueOf(-8000L);
    private static final BigDecimal MIN_INTEGER = BigDecimal.valueOf(Integer.MIN_VALUE);
    private BendableBigDecimalScoreDefinition scoreDefinitionHSS = new BendableBigDecimalScoreDefinition(1, 2);
    private BendableBigDecimalScoreDefinition scoreDefinitionHHSSS = new BendableBigDecimalScoreDefinition(2, 3);

    @Test
    public void parseScore() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{BigDecimal.valueOf(-147L), BigDecimal.valueOf(-258L), BigDecimal.valueOf(-369L)}), (Object)this.scoreDefinitionHSS.parseScore("-147/-258/-369"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        this.scoreDefinitionHSS.parseScore("-147");
    }

    @Test
    public void feasibleHSS() {
        BendableBigDecimalScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_FIVE, MINUS_300, MINUS_4000})});
        BendableBigDecimalScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new BigDecimal[]{ZERO, MINUS_300, MINUS_4000}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{TWO, MINUS_300, MINUS_4000})});
    }

    @Test
    public void addHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_19, MINUS_320, ZERO}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_20, MINUS_20, MINUS_4000}).add(this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, PLUS_4000})));
    }

    @Test
    public void subtractHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_21, PLUS_280, MINUS_8000}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_20, MINUS_20, MINUS_4000}).subtract(this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, PLUS_4000})));
    }

    @Test
    public void divideHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{FIVE, MINUS_FIVE, FIVE}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_25, MINUS_25, PLUS_25}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{FOUR, MINUS_FIVE, FOUR}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_21, MINUS_21, PLUS_21}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{FOUR, MINUS_FIVE, FOUR}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{PLUS_24, MINUS_24, PLUS_24}).divide(5.0));
    }

    @Test
    @Ignore(value="The problem of BigDecimal ^ BigDecimal.")
    public void powerHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{NINE, PLUS_16, PLUS_25}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{THREE, FOUR, FIVE}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{NINE, PLUS_16, PLUS_25}).power(0.5));
    }

    @Test
    public void negateHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_THREE, FOUR, MINUS_FIVE}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE}), (Object)this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_THREE, FOUR, MINUS_FIVE}).negate());
    }

    @Test
    public void equalsAndHashCodeHSS() {
        BendableBigDecimalScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_TEN, MINUS_20, MINUS_30}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_TEN, MINUS_20, MINUS_30})});
    }

    @Test
    public void compareToHSS() {
        BendableBigDecimalScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, MIN_INTEGER}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, MINUS_20}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, ONE}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_4000}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_300}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_20}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, PLUS_300}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, MINUS_300}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, ZERO}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, ONE}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, MINUS_4000}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, MINUS_20}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_20, MINUS_300}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{ONE, MIN_INTEGER, MINUS_20}), this.scoreDefinitionHSS.createScore(new BigDecimal[]{ONE, MINUS_20, MIN_INTEGER})});
    }

    @Test
    public void feasibleHHSSS() {
        BendableBigDecimalScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_FIVE, ZERO, MINUS_300, MINUS_4000, MINUS_5000}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{ZERO, MINUS_FIVE, MINUS_300, MINUS_4000, MINUS_5000})});
        BendableBigDecimalScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{ZERO, ZERO, MINUS_300, MINUS_4000, MINUS_5000}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{ZERO, TWO, MINUS_300, MINUS_4000, MINUS_5000}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{TWO, ZERO, MINUS_300, MINUS_4000, MINUS_5000})});
    }

    @Test
    public void addHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_19, MINUS_320, ZERO, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_20, MINUS_20, MINUS_4000, ZERO, ZERO}).add(this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, PLUS_4000, ZERO, ZERO})));
    }

    @Test
    public void subtractHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_21, PLUS_280, MINUS_8000, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_20, MINUS_20, MINUS_4000, ZERO, ZERO}).subtract(this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, PLUS_4000, ZERO, ZERO})));
    }

    @Test
    public void divideHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{FIVE, MINUS_FIVE, FIVE, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_25, MINUS_25, PLUS_25, ZERO, ZERO}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{FOUR, MINUS_FIVE, FOUR, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_21, MINUS_21, PLUS_21, ZERO, ZERO}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{FOUR, MINUS_FIVE, FOUR, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{PLUS_24, MINUS_24, PLUS_24, ZERO, ZERO}).divide(5.0));
    }

    @Test
    @Ignore(value="The problem of BigDecimal ^ BigDecimal.")
    public void powerHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{NINE, PLUS_16, PLUS_25, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE, ZERO, ZERO}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{THREE, FOUR, FIVE, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{NINE, PLUS_16, PLUS_25, ZERO, ZERO}).power(0.5));
    }

    @Test
    public void negateHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_THREE, FOUR, MINUS_FIVE, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE, ZERO, ZERO}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{THREE, MINUS_FOUR, FIVE, ZERO, ZERO}), (Object)this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_THREE, FOUR, MINUS_FIVE, ZERO, ZERO}).negate());
    }

    @Test
    public void equalsAndHashCodeHHSSS() {
        BendableBigDecimalScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_TEN, MINUS_20, MINUS_30, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_TEN, MINUS_20, MINUS_30, ZERO, ZERO})});
    }

    @Test
    public void compareToHHSSS() {
        BendableBigDecimalScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, MIN_INTEGER, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, MINUS_20, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MIN_INTEGER, ONE, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_4000, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_300, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, MINUS_20, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_300, PLUS_300, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, MINUS_300, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, ZERO, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_20, MINUS_20, ONE, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, MINUS_4000, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_300, MINUS_20, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{MINUS_ONE, MINUS_20, MINUS_300, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{ONE, MIN_INTEGER, MINUS_20, ZERO, ZERO}), this.scoreDefinitionHHSSS.createScore(new BigDecimal[]{ONE, MINUS_20, MIN_INTEGER, ZERO, ZERO})});
    }

    @Test
    public void serializeAndDeserialize() {
        BendableBigDecimalScore input = this.scoreDefinitionHSS.createScore(new BigDecimal[]{MINUS_FIVE, MINUS_300, MINUS_4000});
        PlannerTestUtils.serializeAndDeserializeWithAll(input, new PlannerTestUtils.OutputAsserter<BendableBigDecimalScore>(){

            @Override
            public void assertOutput(BendableBigDecimalScore output) {
                Assert.assertEquals((long)1L, (long)output.getHardLevelsSize());
                Assert.assertEquals((Object)MINUS_FIVE, (Object)output.getHardScore(0));
                Assert.assertEquals((long)2L, (long)output.getSoftLevelsSize());
                Assert.assertEquals((Object)MINUS_300, (Object)output.getSoftScore(0));
                Assert.assertEquals((Object)MINUS_4000, (Object)output.getSoftScore(1));
            }
        });
    }
}

