/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.AbstractScoreTest;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.testdata.util.PlannerTestUtils;

public class BendableLongScoreTest
extends AbstractScoreTest {
    private BendableLongScoreDefinition scoreDefinitionHSS = new BendableLongScoreDefinition(1, 2);
    private BendableLongScoreDefinition scoreDefinitionHHSSS = new BendableLongScoreDefinition(2, 3);

    @Test
    public void parseScore() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{-5432109876L, -9876543210L, -3456789012L}), (Object)this.scoreDefinitionHSS.parseScore("-5432109876/-9876543210/-3456789012"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseScoreIllegalArgument() {
        this.scoreDefinitionHSS.parseScore("-147");
    }

    @Test
    public void feasibleHSS() {
        BendableLongScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new long[]{-5L, -300L, -9876543210L})});
        BendableLongScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHSS.createScore(new long[]{0L, -300L, -9876543210L}), this.scoreDefinitionHSS.createScore(new long[]{2L, -300L, -9876543210L})});
    }

    @Test
    public void addHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{3333333333L, -320L, 0L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{1111111111L, -20L, -9876543210L}).add(this.scoreDefinitionHSS.createScore(new long[]{2222222222L, -300L, 9876543210L})));
    }

    @Test
    public void subtractHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{2222222222L, 280L, -8888888888L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{3333333333L, -20L, -5555555555L}).subtract(this.scoreDefinitionHSS.createScore(new long[]{1111111111L, -300L, 3333333333L})));
    }

    @Test
    public void multiplyHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{6000000000L, -6000000000L, 6000000000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{5000000000L, -5000000000L, 5000000000L}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{1L, -2L, 1L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{1L, -1L, 1L}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{4L, -5L, 4L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{4L, -4L, 4L}).multiply(1.2));
    }

    @Test
    public void divideHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{5000000000L, -5000000000L, 5000000000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{25000000000L, -25000000000L, 25000000000L}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{4L, -5L, 4L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{21L, -21L, 21L}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{4L, -5L, 4L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{24L, -24L, 24L}).divide(5.0));
    }

    @Test
    public void powerHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{90000000000L, 160000000000L, 250000000000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{300000L, -400000L, 500000L}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{300000L, 400000L, 500000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{90000000000L, 160000000000L, 250000000000L}).power(0.5));
    }

    @Test
    public void negateHSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{-3000000000L, 4000000000L, -5000000000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{3000000000L, -4000000000L, 5000000000L}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHSS.createScore(new long[]{3000000000L, -4000000000L, 5000000000L}), (Object)this.scoreDefinitionHSS.createScore(new long[]{-3000000000L, 4000000000L, -5000000000L}).negate());
    }

    @Test
    public void equalsAndHashCodeHSS() {
        BendableLongScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHSS.createScore(new long[]{-10000000000L, -20000000000L, -30000000000L}), this.scoreDefinitionHSS.createScore(new long[]{-10000000000L, -20000000000L, -30000000000L})});
    }

    @Test
    public void compareToHSS() {
        BendableLongScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHSS.createScore(new long[]{-20L, Long.MIN_VALUE, Long.MIN_VALUE}), this.scoreDefinitionHSS.createScore(new long[]{-20L, Long.MIN_VALUE, -20L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, Long.MIN_VALUE, 1L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -300L, -4000L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -300L, -300L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -300L, -20L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -300L, 300L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -20L, -300L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -20L, 0L}), this.scoreDefinitionHSS.createScore(new long[]{-20L, -20L, 1L}), this.scoreDefinitionHSS.createScore(new long[]{-1L, -300L, -4000L}), this.scoreDefinitionHSS.createScore(new long[]{-1L, -300L, -20L}), this.scoreDefinitionHSS.createScore(new long[]{-1L, -20L, -300L}), this.scoreDefinitionHSS.createScore(new long[]{1L, Long.MIN_VALUE, -20L}), this.scoreDefinitionHSS.createScore(new long[]{1L, -20L, Long.MIN_VALUE})});
    }

    @Test
    public void feasibleHHSSS() {
        BendableLongScoreTest.assertScoreNotFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new long[]{-5L, 0L, -300L, -4000000000L, -5000L}), this.scoreDefinitionHHSSS.createScore(new long[]{0L, -5000000000L, -300L, -4000L, -5000L})});
        BendableLongScoreTest.assertScoreFeasible(new FeasibilityScore[]{this.scoreDefinitionHHSSS.createScore(new long[]{0L, 0L, -300000000000L, -4000L, -5000L}), this.scoreDefinitionHHSSS.createScore(new long[]{0L, 2L, -300L, -4000L, -50000000000L}), this.scoreDefinitionHHSSS.createScore(new long[]{2000000000L, 0L, -300L, -4000L, -5000L})});
    }

    @Test
    public void addHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{19000000000L, -320000000000L, 0L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{20000000000L, -20000000000L, -4000000000000L, 0L, 0L}).add(this.scoreDefinitionHHSSS.createScore(new long[]{-1000000000L, -300000000000L, 4000000000000L, 0L, 0L})));
    }

    @Test
    public void subtractHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{21000000000L, 280000000000L, -8000000000000L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{20000000000L, -20000000000L, -4000000000000L, 0L, 0L}).subtract(this.scoreDefinitionHHSSS.createScore(new long[]{-1000000000L, -300000000000L, 4000000000000L, 0L, 0L})));
    }

    @Test
    public void multiplyHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{6000000000L, -6000000000L, 6000000000L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{5000000000L, -5000000000L, 5000000000L, 0L, 0L}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{1L, -2L, 1L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{1L, -1L, 1L, 0L, 0L}).multiply(1.2));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{4L, -5L, 4L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{4L, -4L, 4L, 0L, 0L}).multiply(1.2));
    }

    @Test
    public void divideHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{5000000000L, -5000000000L, 5000000000L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{25000000000L, -25000000000L, 25000000000L, 0L, 0L}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{4L, -5L, 4L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{21L, -21L, 21L, 0L, 0L}).divide(5.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{4L, -5L, 4L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{24L, -24L, 24L, 0L, 0L}).divide(5.0));
    }

    @Test
    public void powerHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{40000000000L, 160000000000L, 250000000000L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{200000L, -400000L, 500000L, 0L, 0L}).power(2.0));
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{3L, 4L, 5L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{9L, 16L, 25L, 0L, 0L}).power(0.5));
    }

    @Test
    public void negateHHSSS() {
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{-3000000000L, 4000000000L, -5000000000L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{3000000000L, -4000000000L, 5000000000L, 0L, 0L}).negate());
        Assert.assertEquals((Object)this.scoreDefinitionHHSSS.createScore(new long[]{3L, -4L, 5L, 0L, 0L}), (Object)this.scoreDefinitionHHSSS.createScore(new long[]{-3L, 4L, -5L, 0L, 0L}).negate());
    }

    @Test
    public void equalsAndHashCodeHHSSS() {
        BendableLongScoreTest.assertScoresEqualsAndHashCode(new Score[]{this.scoreDefinitionHHSSS.createScore(new long[]{-10000000000L, -20000000000L, -30000000000L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-10000000000L, -20000000000L, -30000000000L, 0L, 0L})});
    }

    @Test
    public void compareToHHSSS() {
        BendableLongScoreTest.assertScoreCompareToOrder(new Score[]{this.scoreDefinitionHHSSS.createScore(new long[]{-20L, Long.MIN_VALUE, Long.MIN_VALUE, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, Long.MIN_VALUE, -20L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, Long.MIN_VALUE, 1L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -300L, -4000L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -300L, -300L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -300L, -20L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -300L, 300L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -20L, -300L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -20L, 0L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-20L, -20L, 1L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-1L, -300L, -4000L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-1L, -300L, -20L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{-1L, -20L, -300L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{1L, Long.MIN_VALUE, -20L, 0L, 0L}), this.scoreDefinitionHHSSS.createScore(new long[]{1L, -20L, Long.MIN_VALUE, 0L, 0L})});
    }

    @Test
    public void serializeAndDeserialize() {
        BendableLongScore input = this.scoreDefinitionHSS.createScore(new long[]{-5000000000L, -300000000000L, -4000000000000L});
        PlannerTestUtils.serializeAndDeserializeWithAll(input, new PlannerTestUtils.OutputAsserter<BendableLongScore>(){

            @Override
            public void assertOutput(BendableLongScore output) {
                Assert.assertEquals((long)1L, (long)output.getHardLevelsSize());
                Assert.assertEquals((long)-5000000000L, (long)output.getHardScore(0));
                Assert.assertEquals((long)2L, (long)output.getSoftLevelsSize());
                Assert.assertEquals((long)-300000000000L, (long)output.getSoftScore(0));
                Assert.assertEquals((long)-4000000000000L, (long)output.getSoftScore(1));
            }
        });
    }
}

