/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder;
import org.optaplanner.core.api.score.holder.AbstractScoreHolderTest;

public class HardMediumSoftScoreHolderTest
extends AbstractScoreHolderTest {
    @Test
    public void addConstraintMatchWithConstraintMatch() {
        this.addConstraintMatch(true);
    }

    @Test
    public void addConstraintMatchWithoutConstraintMatch() {
        this.addConstraintMatch(false);
    }

    public void addConstraintMatch(boolean constraintMatchEnabled) {
        HardMediumSoftScoreHolder scoreHolder = new HardMediumSoftScoreHolder(constraintMatchEnabled);
        scoreHolder.addHardConstraintMatch(this.createRuleContext("scoreRule1"), -1000);
        RuleContext ruleContext2 = this.createRuleContext("scoreRule2");
        scoreHolder.addHardConstraintMatch(ruleContext2, -200);
        this.callUnMatch(ruleContext2);
        RuleContext ruleContext3 = this.createRuleContext("scoreRule3");
        scoreHolder.addMediumConstraintMatch(ruleContext3, -30);
        scoreHolder.addMediumConstraintMatch(ruleContext3, -3);
        scoreHolder.addSoftConstraintMatch(this.createRuleContext("scoreRule4"), -4);
        Assert.assertEquals((Object)HardMediumSoftScore.valueOf((int)-1000, (int)-3, (int)-4), (Object)scoreHolder.extractScore());
        if (constraintMatchEnabled) {
            Assert.assertEquals((long)4L, (long)scoreHolder.getConstraintMatchTotals().size());
        }
    }
}

