/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector;

import org.mockito.Mockito;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public abstract class AbstractSelectorConfigTest {
    public HeuristicConfigPolicy buildHeuristicConfigPolicy() {
        return this.buildHeuristicConfigPolicy(TestdataSolution.buildSolutionDescriptor());
    }

    public HeuristicConfigPolicy buildHeuristicConfigPolicy(SolutionDescriptor solutionDescriptor) {
        InnerScoreDirectorFactory scoreDirectorFactory = (InnerScoreDirectorFactory)Mockito.mock(InnerScoreDirectorFactory.class);
        Mockito.when((Object)scoreDirectorFactory.getSolutionDescriptor()).thenReturn((Object)solutionDescriptor);
        Mockito.when((Object)scoreDirectorFactory.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        return new HeuristicConfigPolicy(EnvironmentMode.REPRODUCIBLE, scoreDirectorFactory);
    }
}

