/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor.lateacceptance;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptorTest;
import org.optaplanner.core.impl.localsearch.decider.acceptor.lateacceptance.LateAcceptanceAcceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class LateAcceptanceAcceptorTest
extends AbstractAcceptorTest {
    @Test
    public void lateAcceptanceSize() {
        LateAcceptanceAcceptor acceptor = new LateAcceptanceAcceptor();
        acceptor.setLateAcceptanceSize(3);
        acceptor.setHillClimbingEnabled(false);
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore((Score)SimpleScore.valueOf((int)Integer.MIN_VALUE));
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -500);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope0));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -800)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -2000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope0.setStep(moveScope0.getMove());
        stepScope0.setScore(moveScope0.getScore());
        solverScope.setBestScore(moveScope0.getScore());
        acceptor.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -700);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -900)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -2000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -1000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -1001)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope1.setStep(moveScope1.getMove());
        stepScope1.setScore(moveScope1.getScore());
        acceptor.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope1, -400);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -900)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -1001)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -1000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope2.setStep(moveScope2.getMove());
        stepScope2.setScore(moveScope2.getScore());
        solverScope.setBestScore(moveScope2.getScore());
        acceptor.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
        LocalSearchStepScope stepScope3 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope3 = this.buildMoveScope(stepScope1, -200);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -900)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -500)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -501)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope3));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope3.setStep(moveScope3.getMove());
        stepScope3.setScore(moveScope3.getScore());
        solverScope.setBestScore(moveScope3.getScore());
        acceptor.stepEnded(stepScope3);
        phaseScope.setLastCompletedStepScope(stepScope3);
        LocalSearchStepScope stepScope4 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope4 = this.buildMoveScope(stepScope1, -300);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -700)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope4));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -500)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -701)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -700)));
        stepScope4.setStep(moveScope4.getMove());
        stepScope4.setScore(moveScope4.getScore());
        acceptor.stepEnded(stepScope4);
        phaseScope.setLastCompletedStepScope(stepScope4);
        LocalSearchStepScope stepScope5 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope5 = this.buildMoveScope(stepScope1, -300);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -401)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -400)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope5));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -600)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -401)));
        stepScope5.setStep(moveScope5.getMove());
        stepScope5.setScore(moveScope5.getScore());
        acceptor.stepEnded(stepScope5);
        phaseScope.setLastCompletedStepScope(stepScope5);
        acceptor.phaseEnded(phaseScope);
    }

    @Test
    public void hillClimbingEnabled() {
        LateAcceptanceAcceptor acceptor = new LateAcceptanceAcceptor();
        acceptor.setLateAcceptanceSize(2);
        acceptor.setHillClimbingEnabled(true);
        DefaultSolverScope solverScope = new DefaultSolverScope();
        solverScope.setBestScore((Score)SimpleScore.valueOf((int)-1000));
        LocalSearchPhaseScope phaseScope = new LocalSearchPhaseScope(solverScope);
        LocalSearchStepScope lastCompletedStepScope = new LocalSearchStepScope(phaseScope, -1);
        lastCompletedStepScope.setScore(solverScope.getBestScore());
        phaseScope.setLastCompletedStepScope(lastCompletedStepScope);
        acceptor.phaseStarted(phaseScope);
        LocalSearchStepScope stepScope0 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope0 = this.buildMoveScope(stepScope0, -500);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope0));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -800)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -2000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -1000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope0.setStep(moveScope0.getMove());
        stepScope0.setScore(moveScope0.getScore());
        solverScope.setBestScore(moveScope0.getScore());
        acceptor.stepEnded(stepScope0);
        phaseScope.setLastCompletedStepScope(stepScope0);
        LocalSearchStepScope stepScope1 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope1 = this.buildMoveScope(stepScope1, -700);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -900)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -2000)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope1));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -1000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope1, -1001)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope1.setStep(moveScope1.getMove());
        stepScope1.setScore(moveScope1.getScore());
        acceptor.stepEnded(stepScope1);
        phaseScope.setLastCompletedStepScope(stepScope1);
        LocalSearchStepScope stepScope2 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope2 = this.buildMoveScope(stepScope1, -400);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -700)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -701)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope2, -600)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope2));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -700)));
        stepScope2.setStep(moveScope2.getMove());
        stepScope2.setScore(moveScope2.getScore());
        solverScope.setBestScore(moveScope2.getScore());
        acceptor.stepEnded(stepScope2);
        phaseScope.setLastCompletedStepScope(stepScope2);
        LocalSearchStepScope stepScope3 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope3 = this.buildMoveScope(stepScope1, -200);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -900)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -700)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -701)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope3));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope3, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -900)));
        stepScope3.setStep(moveScope3.getMove());
        stepScope3.setScore(moveScope3.getScore());
        solverScope.setBestScore(moveScope3.getScore());
        acceptor.stepEnded(stepScope3);
        phaseScope.setLastCompletedStepScope(stepScope3);
        LocalSearchStepScope stepScope4 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope4 = this.buildMoveScope(stepScope1, -300);
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -400)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope4));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -500)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope4, -401)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -400)));
        stepScope4.setStep(moveScope4.getMove());
        stepScope4.setScore(moveScope4.getScore());
        acceptor.stepEnded(stepScope4);
        phaseScope.setLastCompletedStepScope(stepScope4);
        LocalSearchStepScope stepScope5 = new LocalSearchStepScope(phaseScope);
        LocalSearchMoveScope moveScope5 = this.buildMoveScope(stepScope1, -300);
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -301)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -400)));
        Assert.assertEquals((Object)true, (Object)acceptor.isAccepted(moveScope5));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -2000)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope5, -600)));
        Assert.assertEquals((Object)false, (Object)acceptor.isAccepted(this.buildMoveScope(stepScope0, -301)));
        stepScope5.setStep(moveScope5.getMove());
        stepScope5.setScore(moveScope5.getScore());
        acceptor.stepEnded(stepScope5);
        phaseScope.setLastCompletedStepScope(stepScope5);
        acceptor.phaseEnded(phaseScope);
    }

    @Test(expected=IllegalArgumentException.class)
    public void zeroLateAcceptanceSize() {
        LateAcceptanceAcceptor acceptor = new LateAcceptanceAcceptor();
        acceptor.setLateAcceptanceSize(0);
        acceptor.phaseStarted(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeLateAcceptanceSize() {
        LateAcceptanceAcceptor acceptor = new LateAcceptanceAcceptor();
        acceptor.setLateAcceptanceSize(-1);
        acceptor.phaseStarted(null);
    }
}

