/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablelong;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.bendablelong.BendableLongScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableLongScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)2L, (long)new BendableLongScoreDefinition(1, 1).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableLongScoreDefinition(3, 4).getLevelsSize());
        Assert.assertEquals((long)7L, (long)new BendableLongScoreDefinition(4, 3).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableLongScoreDefinition(0, 5).getLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableLongScoreDefinition(5, 0).getLevelsSize());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new BendableLongScoreDefinition(1, 1).getFeasibleLevelsSize());
        Assert.assertEquals((long)3L, (long)new BendableLongScoreDefinition(3, 4).getFeasibleLevelsSize());
        Assert.assertEquals((long)4L, (long)new BendableLongScoreDefinition(4, 3).getFeasibleLevelsSize());
        Assert.assertEquals((long)0L, (long)new BendableLongScoreDefinition(0, 5).getFeasibleLevelsSize());
        Assert.assertEquals((long)5L, (long)new BendableLongScoreDefinition(5, 0).getFeasibleLevelsSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createScoreWithIllegalArgument() {
        BendableLongScoreDefinition bendableLongScoreDefinition = new BendableLongScoreDefinition(2, 3);
        bendableLongScoreDefinition.createScore(new long[]{1L, 2L, 3L});
    }

    @Test
    public void createScore() {
        int hardLevelSize = 3;
        int softLevelSize = 2;
        int levelSize = hardLevelSize + softLevelSize;
        long[] scores = new long[levelSize];
        for (int i = 0; i < levelSize; ++i) {
            scores[i] = Integer.MAX_VALUE + (long)i;
        }
        BendableLongScoreDefinition bendableLongScoreDefinition = new BendableLongScoreDefinition(hardLevelSize, softLevelSize);
        BendableLongScore bendableLongScore = bendableLongScoreDefinition.createScore(scores);
        Assert.assertEquals((long)hardLevelSize, (long)bendableLongScore.getHardLevelsSize());
        Assert.assertEquals((long)softLevelSize, (long)bendableLongScore.getSoftLevelsSize());
        for (int i = 0; i < levelSize; ++i) {
            if (i < hardLevelSize) {
                Assert.assertEquals((long)scores[i], (long)bendableLongScore.getHardScore(i));
                continue;
            }
            Assert.assertEquals((long)scores[i], (long)bendableLongScore.getSoftScore(i - hardLevelSize));
        }
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        BendableLongScoreDefinition scoreDefinition = new BendableLongScoreDefinition(2, 3);
        BendableLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)5), scoreDefinition.createScore(new long[]{-1L, -2L, -3L, -4L, -5L}));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getHardScore(0));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getHardScore(1));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getSoftScore(0));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getSoftScore(1));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getSoftScore(2));
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        BendableLongScoreDefinition scoreDefinition = new BendableLongScoreDefinition(2, 3);
        BendableLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)5), scoreDefinition.createScore(new long[]{-1L, -2L, -3L, -4L, -5L}));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore(0));
        Assert.assertEquals((long)-2L, (long)optimisticBound.getHardScore(1));
        Assert.assertEquals((long)-3L, (long)optimisticBound.getSoftScore(0));
        Assert.assertEquals((long)-4L, (long)optimisticBound.getSoftScore(1));
        Assert.assertEquals((long)-5L, (long)optimisticBound.getSoftScore(2));
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        BendableLongScoreDefinition scoreDefinition = new BendableLongScoreDefinition(2, 3);
        BendableLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)5), scoreDefinition.createScore(new long[]{-1L, -2L, -3L, -4L, -5L}));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore(0));
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getHardScore(1));
        Assert.assertEquals((long)-3L, (long)pessimisticBound.getSoftScore(0));
        Assert.assertEquals((long)-4L, (long)pessimisticBound.getSoftScore(1));
        Assert.assertEquals((long)-5L, (long)pessimisticBound.getSoftScore(2));
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        BendableLongScoreDefinition scoreDefinition = new BendableLongScoreDefinition(2, 3);
        BendableLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)5), scoreDefinition.createScore(new long[]{-1L, -2L, -3L, -4L, -5L}));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getHardScore(0));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getHardScore(1));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getSoftScore(0));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getSoftScore(1));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getSoftScore(2));
    }
}

