/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoft;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardMediumSoftScoreDefinitionTest {
    @Test
    public void getLevelsSize() {
        Assert.assertEquals((long)3L, (long)new HardMediumSoftScoreDefinition().getLevelsSize());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new HardMediumSoftScoreDefinition().getFeasibleLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        HardMediumSoftScoreDefinition scoreDefinition = new HardMediumSoftScoreDefinition();
        HardMediumSoftScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)3), HardMediumSoftScore.valueOf((int)-1, (int)-2, (int)-3));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getMediumScore());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        HardMediumSoftScoreDefinition scoreDefinition = new HardMediumSoftScoreDefinition();
        HardMediumSoftScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)3), HardMediumSoftScore.valueOf((int)-1, (int)-2, (int)-3));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)optimisticBound.getMediumScore());
        Assert.assertEquals((long)-3L, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        HardMediumSoftScoreDefinition scoreDefinition = new HardMediumSoftScoreDefinition();
        HardMediumSoftScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)3), HardMediumSoftScore.valueOf((int)-1, (int)-2, (int)-3));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getMediumScore());
        Assert.assertEquals((long)-3L, (long)pessimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        HardMediumSoftScoreDefinition scoreDefinition = new HardMediumSoftScoreDefinition();
        HardMediumSoftScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)3), HardMediumSoftScore.valueOf((int)-1, (int)-2, (int)-3));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getMediumScore());
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)pessimisticBound.getSoftScore());
    }
}

