/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftlong;

import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.hardsoftlong.HardSoftLongScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardSoftLongScoreDefinitionTest {
    @Test
    public void getLevelSize() {
        Assert.assertEquals((long)2L, (long)new HardSoftLongScoreDefinition().getLevelsSize());
    }

    @Test
    public void getFeasibleLevelsSize() {
        Assert.assertEquals((long)1L, (long)new HardSoftLongScoreDefinition().getFeasibleLevelsSize());
    }

    @Test
    public void buildOptimisticBoundOnlyUp() {
        HardSoftLongScoreDefinition scoreDefinition = new HardSoftLongScoreDefinition();
        HardSoftLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftLongScore.valueOf((long)-1L, (long)-2L));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildOptimisticBoundOnlyDown() {
        HardSoftLongScoreDefinition scoreDefinition = new HardSoftLongScoreDefinition();
        HardSoftLongScore optimisticBound = scoreDefinition.buildOptimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftLongScore.valueOf((long)-1L, (long)-2L));
        Assert.assertEquals((long)-1L, (long)optimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)optimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyUp() {
        HardSoftLongScoreDefinition scoreDefinition = new HardSoftLongScoreDefinition();
        HardSoftLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_UP, (int)2), HardSoftLongScore.valueOf((long)-1L, (long)-2L));
        Assert.assertEquals((long)-1L, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)-2L, (long)pessimisticBound.getSoftScore());
    }

    @Test
    public void buildPessimisticBoundOnlyDown() {
        HardSoftLongScoreDefinition scoreDefinition = new HardSoftLongScoreDefinition();
        HardSoftLongScore pessimisticBound = scoreDefinition.buildPessimisticBound(InitializingScoreTrend.buildUniformTrend((InitializingScoreTrendLevel)InitializingScoreTrendLevel.ONLY_DOWN, (int)2), HardSoftLongScore.valueOf((long)-1L, (long)-2L));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getHardScore());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)pessimisticBound.getSoftScore());
    }
}

