/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.BestScoreTermination;

public class BestScoreTerminationTest {
    @Test
    public void solveTermination() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)1);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)SimpleScore.valueOf((int)-1000), new double[0]);
        DefaultSolverScope solverScope = (DefaultSolverScope)Mockito.mock(DefaultSolverScope.class);
        Mockito.when((Object)solverScope.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        Mockito.when((Object)solverScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)solverScope.getStartingInitializedScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)0.6, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1000));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
        Mockito.when((Object)solverScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-900));
        Assert.assertEquals((Object)true, (Object)termination.isSolverTerminated(solverScope));
        Assert.assertEquals((double)1.0, (double)termination.calculateSolverTimeGradient(solverScope), (double)0.0);
    }

    @Test
    public void phaseTermination() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)1);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)SimpleScore.valueOf((int)-1000), new double[0]);
        AbstractPhaseScope phaseScope = (AbstractPhaseScope)Mockito.mock(AbstractPhaseScope.class);
        Mockito.when((Object)phaseScope.getScoreDefinition()).thenReturn((Object)new SimpleScoreDefinition());
        Mockito.when((Object)phaseScope.isBestSolutionInitialized()).thenReturn((Object)true);
        Mockito.when((Object)phaseScope.getStartingScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1100));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1040));
        Assert.assertEquals((Object)false, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)0.6, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-1000));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
        Mockito.when((Object)phaseScope.getBestScore()).thenReturn((Object)SimpleScore.valueOf((int)-900));
        Assert.assertEquals((Object)true, (Object)termination.isPhaseTerminated(phaseScope));
        Assert.assertEquals((double)1.0, (double)termination.calculatePhaseTimeGradient(phaseScope), (double)0.0);
    }

    @Test
    public void calculateTimeGradientSimpleScore() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)1);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)SimpleScore.valueOf((int)10), new double[0]);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)0), (Score)SimpleScore.valueOf((int)10), (Score)SimpleScore.valueOf((int)0)), (double)0.0);
        Assert.assertEquals((double)0.6, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)0), (Score)SimpleScore.valueOf((int)10), (Score)SimpleScore.valueOf((int)6)), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)0), (Score)SimpleScore.valueOf((int)10), (Score)SimpleScore.valueOf((int)10)), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)0), (Score)SimpleScore.valueOf((int)10), (Score)SimpleScore.valueOf((int)11)), (double)0.0);
        Assert.assertEquals((double)0.25, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)-10), (Score)SimpleScore.valueOf((int)30), (Score)SimpleScore.valueOf((int)0)), (double)0.0);
        Assert.assertEquals((double)0.33333, (double)termination.calculateTimeGradient((Score)SimpleScore.valueOf((int)10), (Score)SimpleScore.valueOf((int)40), (Score)SimpleScore.valueOf((int)20)), (double)1.0E-5);
    }

    @Test
    public void calculateTimeGradientSimpleBigDecimalScore() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)1);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), new double[0]);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"))), (double)0.0);
        Assert.assertEquals((double)0.6, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("6.00"))), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"))), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("11.00"))), (double)0.0);
        Assert.assertEquals((double)0.25, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("30.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"))), (double)0.0);
        Assert.assertEquals((double)0.33333, (double)termination.calculateTimeGradient((Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("40.00")), (Score)SimpleBigDecimalScore.valueOf((BigDecimal)new BigDecimal("20.00"))), (double)1.0E-5);
    }

    @Test
    public void calculateTimeGradientHardSoftScore() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)2);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)HardSoftScore.valueOf((int)-10, (int)-300), new double[]{0.75});
        Assert.assertEquals((double)0.6, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-14, (int)-340)), (double)0.0);
        Assert.assertEquals((double)0.75, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-400)), (double)0.0);
        Assert.assertEquals((double)0.25, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-20, (int)-300)), (double)0.0);
        Assert.assertEquals((double)0.75, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-900)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-90, (int)-300)), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-20, (int)-400)), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300)), (double)0.0);
        Assert.assertEquals((double)0.9, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-10, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-340)), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-10, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-20, (int)-340)), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-10, (int)-400), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)0, (int)-340)), (double)0.0);
        Assert.assertEquals((double)0.7, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-14, (int)-300)), (double)0.0);
        Assert.assertEquals((double)0.44999999999999996, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-14, (int)-400)), (double)0.0);
        Assert.assertEquals((double)0.7, (double)termination.calculateTimeGradient((Score)HardSoftScore.valueOf((int)-20, (int)-300), (Score)HardSoftScore.valueOf((int)-10, (int)-300), (Score)HardSoftScore.valueOf((int)-14, (int)0)), (double)0.0);
    }

    @Test
    public void calculateTimeGradientHardSoftBigDecimalScore() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)2);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), new double[]{0.75});
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00"))), (double)0.0);
        Assert.assertEquals((double)0.6, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("6.00"), (BigDecimal)new BigDecimal("6.00"))), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00"))), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("11.00"), (BigDecimal)new BigDecimal("11.00"))), (double)0.0);
        Assert.assertEquals((double)0.25, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("-10.00"), (BigDecimal)new BigDecimal("-10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("30.00"), (BigDecimal)new BigDecimal("30.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("0.00"), (BigDecimal)new BigDecimal("0.00"))), (double)0.0);
        Assert.assertEquals((double)0.33333, (double)termination.calculateTimeGradient((Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("10.00"), (BigDecimal)new BigDecimal("10.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("40.00"), (BigDecimal)new BigDecimal("40.00")), (Score)HardSoftBigDecimalScore.valueOf((BigDecimal)new BigDecimal("20.00"), (BigDecimal)new BigDecimal("20.00"))), (double)1.0E-5);
    }

    @Test
    public void calculateTimeGradientBendableScoreHS() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)2);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), new double[]{0.75});
        Assert.assertEquals((double)0.6, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-14}, (int[])new int[]{-340})), (double)0.0);
        Assert.assertEquals((double)0.75, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-400})), (double)0.0);
        Assert.assertEquals((double)0.25, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-300})), (double)0.0);
        Assert.assertEquals((double)0.75, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-900})), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-90}, (int[])new int[]{-300})), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300})), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400})), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300})), (double)0.0);
        Assert.assertEquals((double)0.9, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-340})), (double)0.0);
        Assert.assertEquals((double)0.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-340})), (double)0.0);
        Assert.assertEquals((double)1.0, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-400}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{0}, (int[])new int[]{-340})), (double)0.0);
        Assert.assertEquals((double)0.7, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-14}, (int[])new int[]{-300})), (double)0.0);
        Assert.assertEquals((double)0.44999999999999996, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-14}, (int[])new int[]{-400})), (double)0.0);
        Assert.assertEquals((double)0.7, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-20}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-10}, (int[])new int[]{-300}), (Score)BendableScore.valueOf((int[])new int[]{-14}, (int[])new int[]{0})), (double)0.0);
    }

    @Test
    public void calculateTimeGradientBendableScoreHHSSS() {
        ScoreDefinition scoreDefinition = (ScoreDefinition)Mockito.mock(ScoreDefinition.class);
        Mockito.when((Object)scoreDefinition.getLevelsSize()).thenReturn((Object)5);
        BestScoreTermination termination = new BestScoreTermination(scoreDefinition, (Score)BendableScore.valueOf((int[])new int[]{0, 0}, (int[])new int[]{0, 0, -10}), new double[]{0.75, 0.75, 0.75, 0.75});
        Assert.assertEquals((double)0.5625, (double)termination.calculateTimeGradient((Score)BendableScore.valueOf((int[])new int[]{-10, -100}, (int[])new int[]{-50, -60, -70}), (Score)BendableScore.valueOf((int[])new int[]{0, 0}, (int[])new int[]{0, 0, -10}), (Score)BendableScore.valueOf((int[])new int[]{-4, -40}, (int[])new int[]{-50, -60, -70})), (double)0.0);
    }
}

